/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.ext;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;

public class ClassMediator
extends AbstractMediator
implements ManagedLifecycle {
    private Mediator mediator = null;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public boolean mediate(MessageContext synCtx) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Class mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("invoking : " + this.mediator.getClass() + ".mediate()");
        }
        try {
            result = this.mediator.mediate(synCtx);
        }
        catch (Exception e) {
            throw new SynapseException("Error occured in the mediation of the class mediator", e);
        }
        synLog.traceOrDebug("End : Class mediator");
        return result;
    }

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying class mediator instance for : " + this.mediator.getClass()));
        }
        if (this.mediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.mediator)).destroy();
        }
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing class mediator instance for : " + this.mediator.getClass()));
        }
        if (this.mediator == null) {
            this.log.warn((Object)"init() called before mediator reference set");
            return;
        }
        if (this.mediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.mediator)).init(se);
        }
    }

    public void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    public Mediator getMediator() {
        return this.mediator;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Map getProperties() {
        return this.properties;
    }

    @Override
    public boolean isContentAware() {
        return this.mediator.isContentAware();
    }
}

