/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.resequence;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.processors.resequence.ResequencingProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ResequencingJob
implements Job {
    private static final Log log = LogFactory.getLog(ResequencingJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String result;
        JobDataMap jdm = jobExecutionContext.getMergedJobDataMap();
        MessageStore messageStore = (MessageStore)jdm.get((Object)"message.store");
        ResequencingProcessor processor = (ResequencingProcessor)jdm.get((Object)"processor.instance");
        Map parameters = (Map)jdm.get((Object)"parameters");
        String sequence = (String)parameters.get("nextEsbSequence");
        SynapseXPath seqNoxPath = null;
        if (!processor.isActive() || messageStore == null) {
            return;
        }
        if (parameters.get("seqNumXpath") != null) {
            seqNoxPath = (SynapseXPath)((Object)parameters.get("seqNumXpath"));
        }
        if (parameters.get("requiredInitMessages") != null) {
            processor.setRequiredInitMsgs(new AtomicInteger(Integer.parseInt((String)parameters.get("requiredInitMessages"))));
        }
        if (parameters.get("requiredInitMessagesDelay") != null) {
            processor.setRequiredInitMsgsDelay(new AtomicInteger(Integer.parseInt((String)parameters.get("requiredInitMessagesDelay"))));
        }
        if (parameters.get("deleteDuplicateMessages") != null && (result = (String)parameters.get("deleteDuplicateMessages")).equalsIgnoreCase("TRUE")) {
            processor.setDeleteDuplicates(new AtomicBoolean(true));
        }
        if (!processor.isInitSeqNo().get()) {
            processor.deactivate();
            do {
                this.delay(6000L);
                if (messageStore.size() >= processor.getRequiredInitMsgs().get()) {
                    this.selectStartingSeqNo(processor, messageStore, seqNoxPath);
                    break;
                }
                ++processor.tried;
            } while (processor.tried < processor.getRequiredInitMsgsDelay().get());
        }
        if (!processor.isInitSeqNo().get()) {
            while (messageStore.size() <= 0) {
            }
            this.selectStartingSeqNo(processor, messageStore, seqNoxPath);
            if (!processor.isInitSeqNo().get()) {
                log.warn((Object)"Resequencer failed to select starting sequence number with in given timeout !");
            }
        }
        boolean errorStop = false;
        block4: while (!errorStop) {
            int messageIndex = 0;
            while (true) {
                block19: {
                    int sequenceNo;
                    MessageContext messageContext;
                    if ((messageContext = messageStore.get(messageIndex)) == null) {
                        errorStop = true;
                        continue block4;
                    }
                    try {
                        sequenceNo = Integer.parseInt(seqNoxPath.stringValueOf(messageContext));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Can't Find sequence number from message " + e.getMessage()));
                        break block19;
                    }
                    String messageId = messageContext.getMessageID();
                    if (sequenceNo < processor.getNextSeqNo() && processor.getDeleteDuplicates()) {
                        messageStore.remove(messageId);
                    }
                    if (sequenceNo == processor.getNextSeqNo()) {
                        messageStore.remove(messageId);
                        if (!this.send(messageContext, sequence)) continue block4;
                        processor.incrementNextSeqNo();
                        continue block4;
                    }
                }
                ++messageIndex;
            }
        }
        if (!processor.isActive()) {
            processor.activate();
        }
    }

    private void selectStartingSeqNo(ResequencingProcessor processor, MessageStore messageStore, SynapseXPath seqNoxPath) {
        int messageIndex = 0;
        while (true) {
            try {
                MessageContext messageContext = messageStore.get(messageIndex);
                if (messageContext == null) break;
                int sequenceNo = Integer.parseInt(seqNoxPath.stringValueOf(messageContext));
                if (sequenceNo < processor.getNextSeqNo()) {
                    processor.setNextSeqNo(sequenceNo);
                    processor.setInitSeqNo(new AtomicBoolean(true));
                }
            }
            catch (NumberFormatException e) {
                ResequencingJob.handleException("Invalid xPath parameter - Sequence number specified is not an integer ");
            }
            catch (Exception e) {
                ResequencingJob.handleException("Failed to initialize starting sequence number at startup: " + e.getMessage());
            }
            ++messageIndex;
        }
    }

    private void delay(long timePeriod) {
        try {
            Thread.sleep(timePeriod);
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted while thread sleeping in resequencer", (Throwable)e);
        }
    }

    private boolean send(MessageContext messageContext, String sequence) {
        Mediator processingSequence = messageContext.getSequence(sequence);
        if (processingSequence != null) {
            processingSequence.mediate(messageContext);
            return true;
        }
        return false;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

