/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.sampler;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.processors.sampler.SamplingProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SamplingJob
implements Job {
    private static Log log = LogFactory.getLog(SamplingJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jdm = jobExecutionContext.getMergedJobDataMap();
        MessageStore messageStore = (MessageStore)jdm.get((Object)"message.store");
        Map parameters = (Map)jdm.get((Object)"parameters");
        SamplingProcessor processor = (SamplingProcessor)jdm.get((Object)"processor.instance");
        Object concurrency = jdm.get((Object)"concurrency");
        final String sequence = (String)parameters.get("sequence");
        if (!processor.isActive()) {
            return;
        }
        int conc = 1;
        if (concurrency instanceof Integer) {
            conc = (Integer)concurrency;
        }
        for (int i = 0; i < conc; ++i) {
            MessageStore messageStore2 = messageStore;
            synchronized (messageStore2) {
                final MessageContext messageContext = messageStore.peek();
                if (messageContext != null) {
                    messageStore.poll();
                    ExecutorService executor = messageContext.getEnvironment().getExecutorService();
                    executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Mediator processingSequence = messageContext.getSequence(sequence);
                                if (processingSequence != null) {
                                    processingSequence.mediate(messageContext);
                                }
                            }
                            catch (Throwable t) {
                                log.error((Object)"Error occurred while executing the message", t);
                            }
                        }
                    });
                }
                continue;
            }
        }
    }
}

