/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.synapse.util.PayloadHelper;
import org.apache.synapse.util.SimpleMap;

public class SimpleMapImpl
extends HashMap
implements SimpleMap {
    private static final OMNamespace attrNS = OMAbstractFactory.getOMFactory().createOMNamespace("", "");
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String ENTRY = "entry";
    private static final String SHORT = "short";
    private static final String LONG = "long";
    private static final String DOUBLE = "double";
    private static final String INTEGER = "int";
    private static final String FLOAT = "float";
    private static final String BYTEARRAY = "byte[]";
    private static final String BYTE = "byte";
    private static final String STRING = "string";
    private static final String BOOLEAN = "boolean";
    private static final String CHAR = "char";
    private static final long serialVersionUID = 1L;

    public SimpleMapImpl() {
    }

    @Override
    public Object get(String name) {
        return this.get((Object)name);
    }

    @Override
    public boolean getBoolean(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new RuntimeException("getBoolean(" + name + "): " + o.getClass().getName() + " is not an instance of Boolean");
    }

    @Override
    public byte getByte(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Byte) {
            return (Byte)o;
        }
        throw new RuntimeException("getByte(" + name + "): " + o.getClass().getName() + " is not an instance of Byte");
    }

    @Override
    public byte[] getBytes(String name) {
        Object o = this.get((Object)name);
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        throw new RuntimeException("getByteArray(" + name + "): " + o.getClass().getName() + " is not an instance of byte[]");
    }

    @Override
    public char getChar(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw new RuntimeException("getChar(" + name + "): " + o.getClass().getName() + " is not an instance of Character");
    }

    @Override
    public double getDouble(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new RuntimeException("getDouble(" + name + "): " + o.getClass().getName() + " is not an instance of Double");
    }

    @Override
    public float getFloat(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        throw new RuntimeException("getFloat(" + name + "): " + o.getClass().getName() + " is not an instance of Float");
    }

    @Override
    public int getInt(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new RuntimeException("getInt(" + name + "): " + o.getClass().getName() + " is not an instance of Integer");
    }

    @Override
    public long getLong(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new RuntimeException("getLong(" + name + "): " + o.getClass().getName() + " is not an instance of Long");
    }

    @Override
    public short getShort(String name) {
        Object o = this.get((Object)name);
        if (o instanceof Short) {
            return (Short)o;
        }
        throw new RuntimeException("getShort(" + name + "): " + o.getClass().getName() + " is not an instance of Short");
    }

    @Override
    public String getString(String name) {
        Object o = this.get((Object)name);
        if (o instanceof String) {
            return (String)o;
        }
        throw new RuntimeException("getString(" + name + "): " + o.getClass().getName() + " is not an instance of String");
    }

    @Override
    public void put(String name, Object value) {
        this.put(name, value);
    }

    @Override
    public void putBoolean(String name, boolean b) {
        this.put(name, b);
    }

    @Override
    public void putByte(String name, byte b) {
        this.put(name, b);
    }

    @Override
    public void putBytes(String name, byte[] bytes) {
        this.put(name, bytes);
    }

    @Override
    public void putChar(String name, char c) {
        this.put(name, Character.valueOf(c));
    }

    @Override
    public void putDouble(String name, double d) {
        this.put(name, d);
    }

    @Override
    public void putFloat(String name, float fl) {
        this.put(name, Float.valueOf(fl));
    }

    @Override
    public void putInt(String name, int i) {
        this.put(name, i);
    }

    @Override
    public void putLong(String name, long l) {
        this.put(name, l);
    }

    @Override
    public void putShort(String name, short s) {
        this.put(name, s);
    }

    @Override
    public void putString(String name, String value) {
        this.put(name, value);
    }

    public OMElement getOMElement() {
        return this.getOMElement(OMAbstractFactory.getOMFactory());
    }

    public OMElement getOMElement(OMFactory fac) {
        OMElement mapElement = fac.createOMElement(PayloadHelper.MAPELT);
        for (Map.Entry entryObj : this.entrySet()) {
            Object key = entryObj.getKey();
            Object o = entryObj.getValue();
            if (!(key instanceof String)) continue;
            OMElement entry = fac.createOMElement(new QName("http://ws.apache.org/commons/ns/payload", ENTRY), (OMContainer)mapElement);
            entry.addAttribute(NAME, (String)key, attrNS);
            if (o instanceof Character) {
                entry.addAttribute(TYPE, CHAR, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (o instanceof Boolean) {
                entry.addAttribute(TYPE, BOOLEAN, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (o instanceof String) {
                entry.addAttribute(TYPE, STRING, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (o instanceof Byte) {
                entry.addAttribute(TYPE, BYTE, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (o instanceof byte[]) {
                entry.addAttribute(TYPE, BYTEARRAY, attrNS);
                OMText text = fac.createOMText((Object)new DataHandler((DataSource)new ByteArrayDataSource((byte[])o)), true);
                entry.addChild((OMNode)text);
                continue;
            }
            if (o instanceof Float) {
                entry.addAttribute(TYPE, FLOAT, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (o instanceof Double) {
                entry.addAttribute(TYPE, DOUBLE, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (o instanceof Long) {
                entry.addAttribute(TYPE, LONG, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (o instanceof Short) {
                entry.addAttribute(TYPE, SHORT, attrNS);
                entry.setText(o.toString());
                continue;
            }
            if (!(o instanceof Integer)) continue;
            entry.addAttribute(TYPE, INTEGER, attrNS);
            entry.setText(o.toString());
        }
        return mapElement;
    }

    public SimpleMapImpl(OMElement el) {
        if (el.getQName().equals(PayloadHelper.MAPELT)) {
            Iterator it = el.getChildElements();
            while (it.hasNext()) {
                OMNode data;
                OMElement child = (OMElement)it.next();
                if (!child.getLocalName().equals(ENTRY)) continue;
                String name = child.getAttributeValue(new QName("", NAME));
                String type = child.getAttributeValue(new QName("", TYPE));
                if (type == null || name == null || (data = child.getFirstOMChild()).getType() != 4) continue;
                OMText text = (OMText)data;
                if (type.equals(INTEGER)) {
                    this.put(name, new Integer(text.getText()));
                    continue;
                }
                if (type.equals(CHAR)) {
                    this.put(name, Character.valueOf(text.getText().charAt(0)));
                    continue;
                }
                if (type.equals(DOUBLE)) {
                    this.put(name, new Double(text.getText()));
                    continue;
                }
                if (type.equals(FLOAT)) {
                    this.put(name, new Float(text.getText()));
                    continue;
                }
                if (type.equals(BYTE)) {
                    this.put(name, (Object)text.getText().getBytes()[0]);
                    continue;
                }
                if (type.equals(SHORT)) {
                    this.put(name, new Short(text.getText()));
                    continue;
                }
                if (type.equals(LONG)) {
                    this.put(name, new Long(text.getText()));
                    continue;
                }
                if (type.equals(STRING)) {
                    this.put(name, text.getText());
                    continue;
                }
                if (!type.equals(BYTEARRAY)) continue;
                DataHandler dh = (DataHandler)text.getDataHandler();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    dh.writeTo((OutputStream)baos);
                    this.put(name, baos.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

