/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;

public class DataSourceBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgContext) throws AxisFault {
        byte[] bytes;
        msgContext.setDoingREST(true);
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("", "");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferUtils.inputStream2OutputStream((InputStream)inputStream, (OutputStream)baos);
            baos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
        ByteArrayDataSourceEx ds = new ByteArrayDataSourceEx(bytes, contentType);
        return factory.createOMElement((OMDataSource)ds, "dummy", ns);
    }

    public class ByteArrayDataSourceEx
    extends ByteArrayDataSource
    implements OMDataSource {
        private byte[] bytes;

        public ByteArrayDataSourceEx(byte[] bytes, String s) {
            super(bytes, s);
            this.bytes = bytes;
        }

        public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
            try {
                output.write(this.bytes);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        public String getContentType() {
            return super.getContentType();
        }

        public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
            throw new UnsupportedOperationException("FIXME");
        }

        public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
            throw new UnsupportedOperationException("FIXME");
        }

        public XMLStreamReader getReader() throws XMLStreamException {
            throw new UnsupportedOperationException("FIXME");
        }
    }
}

