/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessController {
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return action.run();
        }
        return java.security.AccessController.doPrivileged(action);
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return action.run();
        }
        return java.security.AccessController.doPrivileged(action, context);
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return java.security.AccessController.doPrivileged(action);
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return java.security.AccessController.doPrivileged(action, context);
    }

    public static AccessControlContext getContext() {
        return java.security.AccessController.getContext();
    }

    public static void checkPermission(Permission perm) throws AccessControlException {
        java.security.AccessController.checkPermission(perm);
    }

    private AccessController() {
    }
}

