/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.impl.EndpointInterfaceDescriptionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodRetriever {
    private static final Log log = LogFactory.getLog(MethodRetriever.class);
    private String legacyWebMethod = null;

    public String getLegacyWebMethod() {
        return this.legacyWebMethod;
    }

    public void setLegacyWebMethod(String legacyWebMethod) {
        this.legacyWebMethod = legacyWebMethod;
    }

    protected MethodRetriever() {
    }

    public abstract Iterator<MethodDescriptionComposite> retrieveMethods();

    protected ArrayList<MethodDescriptionComposite> retrieveSEIMethodsChain(DescriptionBuilderComposite tmpDBC, EndpointInterfaceDescriptionImpl eid) {
        DescriptionBuilderComposite dbc = tmpDBC;
        ArrayList<MethodDescriptionComposite> retrieveList = new ArrayList();
        retrieveList = this.retrieveSEIMethods(dbc);
        Iterator<String> iter = null;
        List<String> interfacesList = dbc.getInterfacesList();
        if (interfacesList != null) {
            for (String interfaceName : dbc.getInterfacesList()) {
                DescriptionBuilderComposite superInterface = eid.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap().get(interfaceName);
                retrieveList.addAll(this.retrieveSEIMethodsChain(superInterface, eid));
            }
        }
        return retrieveList;
    }

    protected ArrayList<MethodDescriptionComposite> removeOverriddenMethods(ArrayList<MethodDescriptionComposite> methodList, DescriptionBuilderComposite dbc, EndpointInterfaceDescriptionImpl eid) {
        Map<String, Integer> hierarchyMap = dbc.isInterface() ? this.getInterfaceHierarchy(dbc, eid) : this.getClassHierarchy(dbc, eid);
        ArrayList<MethodDescriptionComposite> returnMethods = new ArrayList<MethodDescriptionComposite>();
        for (int i = 0; i < methodList.size(); ++i) {
            if (!this.notFound(returnMethods, methodList.get(i))) continue;
            returnMethods.add(MethodRetriever.getBaseMethod(methodList.get(i), i, methodList, hierarchyMap));
        }
        return returnMethods;
    }

    private Map<String, Integer> getInterfaceHierarchy(DescriptionBuilderComposite dbc, EndpointInterfaceDescriptionImpl eid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting interface hierarchy for: " + dbc.getClassName()));
        }
        HashMap<String, Integer> hierarchyMap = new HashMap<String, Integer>();
        hierarchyMap.put(dbc.getClassName(), 0);
        return this.getInterfaceHierarchy(dbc.getInterfacesList(), hierarchyMap, 1, eid);
    }

    protected ArrayList<MethodDescriptionComposite> retrieveSEIMethods(DescriptionBuilderComposite dbc) {
        ArrayList<MethodDescriptionComposite> retrieveList = new ArrayList<MethodDescriptionComposite>();
        Iterator<MethodDescriptionComposite> iter = null;
        List<MethodDescriptionComposite> mdcList = dbc.getMethodDescriptionsList();
        if (mdcList != null) {
            for (MethodDescriptionComposite mdc : dbc.getMethodDescriptionsList()) {
                mdc.setDeclaringClass(dbc.getClassName());
                retrieveList.add(mdc);
            }
        }
        return retrieveList;
    }

    private HashMap<String, Integer> getClassHierarchy(DescriptionBuilderComposite dbc, EndpointInterfaceDescriptionImpl eid) {
        HashMap<String, DescriptionBuilderComposite> dbcMap = eid.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap();
        HashMap<String, Integer> hierarchyMap = new HashMap<String, Integer>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting class at base level: " + dbc.getClassName()));
        }
        hierarchyMap.put(dbc.getClassName(), 0);
        DescriptionBuilderComposite superDBC = dbcMap.get(dbc.getSuperClassName());
        int i = 1;
        while (superDBC != null && !superDBC.getClassName().equals("java.lang.Object")) {
            hierarchyMap.put(superDBC.getClassName(), i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Putting class: " + superDBC.getClassName() + " at hierarchy rank: " + i));
            }
            ++i;
            superDBC = dbcMap.get(superDBC.getSuperClassName());
        }
        return hierarchyMap;
    }

    private boolean notFound(ArrayList<MethodDescriptionComposite> mdcList, MethodDescriptionComposite mdc) {
        for (MethodDescriptionComposite method : mdcList) {
            if (!mdc.compare(method)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Integer> getInterfaceHierarchy(List<String> interfaces, Map<String, Integer> hierarchyMap, int level, EndpointInterfaceDescriptionImpl eid) {
        HashMap<String, DescriptionBuilderComposite> dbcMap = eid.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap();
        if (interfaces != null && !interfaces.isEmpty()) {
            for (String interfaze : interfaces) {
                DescriptionBuilderComposite interDBC = dbcMap.get(interfaze);
                if (interDBC == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserting super interface " + interDBC.getClassName() + " at level " + level));
                }
                hierarchyMap.put(interDBC.getClassName(), level);
                return this.getInterfaceHierarchy(interDBC.getInterfacesList(), hierarchyMap, level++, eid);
            }
        }
        return hierarchyMap;
    }

    private static MethodDescriptionComposite getBaseMethod(MethodDescriptionComposite mdc, int index, ArrayList<MethodDescriptionComposite> methodList, Map<String, Integer> hierarchyMap) {
        int baseLevel = hierarchyMap.get(mdc.getDeclaringClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Base method: " + mdc.getMethodName() + " initial level: " + baseLevel));
        }
        while (index < methodList.size()) {
            MethodDescriptionComposite compareMDC = methodList.get(index);
            if (mdc.equals(compareMDC)) {
                int compareLevel;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found equivalent methods: " + mdc.getMethodName()));
                }
                if ((compareLevel = hierarchyMap.get(compareMDC.getDeclaringClass()).intValue()) < baseLevel) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found method lower in hierarchy chain: " + compareMDC.getMethodName() + " of class: " + compareMDC.getMethodName()));
                    }
                    mdc = compareMDC;
                    baseLevel = compareLevel;
                }
            }
            ++index;
        }
        return mdc;
    }
}

