/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import com.rabbitmq.client.BasicProperties;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.QueueingConsumer;
import java.util.Date;
import java.util.Map;

public class AMQPTransportMessage {
    private String soapAction;
    private String messageId;
    private String contentType;
    private String contentEncoding;
    private Integer deliveryMode;
    private Integer priority;
    private String correlationId;
    private String replyTo;
    private String expiration;
    private Date timestamp;
    private String type;
    private String userId;
    private String appId;
    private String clusterId;
    private Map<String, Object> headers;
    private byte[] body;
    private Envelope envelope;
    private BasicProperties basicProperties;
    private QueueingConsumer.Delivery delivery;

    public AMQPTransportMessage(QueueingConsumer.Delivery delivery) {
        this.delivery = delivery;
        this.body = delivery.getBody();
        this.envelope = delivery.getEnvelope();
        this.basicProperties = delivery.getProperties();
        this.messageId = delivery.getProperties().getMessageId();
        this.contentType = delivery.getProperties().getContentType();
        this.contentEncoding = delivery.getProperties().getContentEncoding();
        this.deliveryMode = delivery.getProperties().getDeliveryMode();
        this.priority = delivery.getProperties().getPriority();
        this.correlationId = delivery.getProperties().getCorrelationId();
        this.replyTo = delivery.getProperties().getReplyTo();
        this.expiration = delivery.getProperties().getExpiration();
        this.timestamp = delivery.getProperties().getTimestamp();
        this.type = delivery.getProperties().getType();
        this.userId = delivery.getProperties().getUserId();
        this.appId = delivery.getProperties().getAppId();
        this.clusterId = delivery.getProperties().getClusterId();
        this.headers = delivery.getProperties().getHeaders();
        if (delivery.getProperties().getHeaders() != null) {
            this.soapAction = (String)delivery.getProperties().getHeaders().get("SOAPAction");
        }
    }

    public AMQPTransportMessage(BasicProperties basicProperties, byte[] message) {
        this.body = message;
        this.basicProperties = basicProperties;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public QueueingConsumer.Delivery getDelivery() {
        return this.delivery;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }
}

