/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.sendertask;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportUtils;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactory;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactoryManager;
import org.apache.synapse.transport.amqp.sendertask.AMQPSender;

public class AMQPSenderFactory {
    private static Log log = LogFactory.getLog(AMQPSenderFactory.class);

    public static synchronized AMQPSender createAMQPSender(AMQPTransportConnectionFactoryManager connectionFactoryManager, Map<String, String> params) throws IOException {
        Map<String, String> conFacParam;
        Boolean value;
        String exchangeType;
        AMQPTransportConnectionFactory connFac;
        boolean isQueueDurable = false;
        boolean isQueueRestricted = false;
        boolean isQueueAutoDelete = true;
        boolean isExchangeDurable = false;
        boolean isExchangeAutoDelete = true;
        boolean isInternalExchange = false;
        AMQPSender as = new AMQPSender();
        try {
            connFac = connectionFactoryManager.getConnectionFactory(params.get("transport.amqp.ConnectionFactoryName"));
            Channel channel = connFac.getChannel();
            as.setChannel(channel);
        }
        catch (AMQPTransportException e) {
            throw new AxisFault("Could not retrieve the channel", (Throwable)e);
        }
        String exchangeName = params.get("transport.amqp.ExchangeName");
        if (exchangeName != null) {
            as.setExchangeName(exchangeName);
        }
        if ((exchangeType = params.get("transport.amqp.ExchangeType")) == null) {
            exchangeType = "direct";
        }
        if ((value = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsExchangeDurable", params, conFacParam = connFac.getParameters())) != null) {
            isExchangeDurable = value;
        }
        if ((value = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsExchangeAutoDelete", params, conFacParam)) != null) {
            isExchangeAutoDelete = value;
        }
        if ((value = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.ExchangeInternal", params, conFacParam)) != null) {
            isInternalExchange = value;
        }
        String queueName = params.get("transport.amqp.QueueName");
        as.setQueueName(queueName);
        String routingKey = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.RoutingKey", params, conFacParam);
        if (routingKey != null) {
            as.setRoutingKey(routingKey);
        }
        if ((value = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsQueueDurable", params, conFacParam)) != null) {
            isQueueDurable = value;
        }
        if ((value = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsQueueRestricted", params, conFacParam)) != null) {
            isQueueRestricted = value;
        }
        if ((value = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsQueueAutoDelete", params, conFacParam)) != null) {
            isQueueAutoDelete = value;
        }
        return as;
    }
}

