/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.gpu.ArithmeticBinaryGPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;
import org.apache.sysml.utils.GPUStatistics;

public class ScalarMatrixArithmeticGPUInstruction
extends ArithmeticBinaryGPUInstruction {
    protected ScalarMatrixArithmeticGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        CPOperand mat = this._input1.getDataType() == Expression.DataType.MATRIX ? this._input1 : this._input2;
        CPOperand scalar = this._input1.getDataType() == Expression.DataType.MATRIX ? this._input2 : this._input1;
        MatrixObject in1 = this.getMatrixInputForGPUInstruction(ec, mat.getName());
        ScalarObject constant = ec.getScalarInput(scalar.getName(), scalar.getValueType(), scalar.isLiteral());
        boolean isTransposed = false;
        int rlen = isTransposed ? (int)in1.getNumColumns() : (int)in1.getNumRows();
        int clen = isTransposed ? (int)in1.getNumRows() : (int)in1.getNumColumns();
        ec.setMetaData(this._output.getName(), rlen, clen);
        ScalarOperator sc_op = (ScalarOperator)this._optr;
        sc_op = sc_op.setConstant(constant.getDoubleValue());
        LibMatrixCUDA.matrixScalarArithmetic(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, this._output.getName(), isTransposed, sc_op);
        ec.releaseMatrixInputForGPUInstruction(mat.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

