/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api.jmlc;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.jmlc.JMLCUtils;
import org.apache.sysds.api.jmlc.PreparedScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.hops.rewrite.ProgramRewriter;
import org.apache.sysds.hops.rewrite.RewriteRemovePersistentReadWrite;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DMLTranslator;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.parser.ParserFactory;
import org.apache.sysds.parser.ParserWrapper;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.FrameReaderFactory;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.MatrixReaderFactory;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.MetaDataAll;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.CollectionUtils;
import org.apache.sysds.runtime.util.DataConverter;

public class Connection
implements Closeable {
    private final DMLConfig _dmlconf;
    private final CompilerConfig _cconf;
    private static FileSystem fs = null;

    public Connection() {
        this(new DMLConfig());
    }

    public Connection(CompilerConfig.ConfigType ... cconfigs) {
        this(new DMLConfig());
        for (CompilerConfig.ConfigType configType : cconfigs) {
            this._cconf.set(configType, true);
        }
        this.setLocalConfigs();
    }

    public Connection(DMLConfig dmlconfig, CompilerConfig.ConfigType ... cconfigs) {
        this(dmlconfig);
        for (CompilerConfig.ConfigType configType : cconfigs) {
            this._cconf.set(configType, true);
        }
        this.setLocalConfigs();
    }

    public Connection(DMLConfig dmlconfig) {
        DMLScript.setGlobalExecMode(Types.ExecMode.SINGLE_NODE);
        CompilerConfig cconf = new CompilerConfig();
        cconf.set(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS, true);
        cconf.set(CompilerConfig.ConfigType.IGNORE_READ_WRITE_METADATA, true);
        cconf.set(CompilerConfig.ConfigType.IGNORE_TEMPORARY_FILENAMES, true);
        cconf.set(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_MATRIX_OPERATIONS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_LOCAL_OR_REMOTE_PARFOR, false);
        cconf.set(CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION, false);
        cconf.set(CompilerConfig.ConfigType.ALLOW_INDIVIDUAL_SB_SPECIFIC_OPS, false);
        cconf.set(CompilerConfig.ConfigType.ALLOW_CSE_PERSISTENT_READS, false);
        cconf.set(CompilerConfig.ConfigType.CODEGEN_ENABLED, false);
        this._cconf = cconf;
        CacheableData.disableCaching();
        this._dmlconf = dmlconfig;
        this.setLocalConfigs();
    }

    public void setStatistics(boolean stats) {
        DMLScript.STATISTICS = stats;
    }

    public void setLineage(boolean lt) {
        DMLScript.LINEAGE = lt;
        Lineage.resetInternalState();
    }

    public void gatherMemStats(boolean stats) {
        DMLScript.STATISTICS = stats || DMLScript.STATISTICS;
        DMLScript.JMLC_MEM_STATISTICS = stats;
    }

    public PreparedScript prepareScript(String script, String[] inputs, String[] outputs) {
        return this.prepareScript(script, Collections.emptyMap(), inputs, outputs);
    }

    public PreparedScript prepareScript(String script, Map<String, String> args, String[] inputs, String[] outputs) {
        return this.prepareScript(script, Collections.emptyMap(), args, inputs, outputs);
    }

    public PreparedScript prepareScript(String script, Map<String, String> nsscripts, Map<String, String> args, String[] inputs, String[] outputs) {
        Object[] invalidArgs = (String[])args.keySet().stream().filter(k -> k == null || !k.startsWith("$")).toArray(String[]::new);
        if (invalidArgs.length > 0) {
            throw new LanguageException("Invalid argument names: " + Arrays.toString(invalidArgs));
        }
        Object[] invalidVars = (String[])CollectionUtils.asSet(new String[][]{inputs, outputs}).stream().filter(k -> k == null || k.startsWith("$")).toArray(String[]::new);
        if (invalidVars.length > 0) {
            throw new LanguageException("Invalid variable names: " + Arrays.toString(invalidVars));
        }
        this.setLocalConfigs();
        Program rtprog = null;
        try {
            ParserWrapper parser = ParserFactory.createParser(nsscripts);
            DMLProgram prog = parser.parse(null, script, args);
            DMLTranslator dmlt = new DMLTranslator(prog);
            dmlt.liveVariableAnalysis(prog);
            dmlt.validateParseTree(prog);
            dmlt.constructHops(prog);
            dmlt.rewriteHopsDAG(prog);
            RewriteRemovePersistentReadWrite rewrite = new RewriteRemovePersistentReadWrite(inputs, outputs);
            ProgramRewriter rewriter2 = new ProgramRewriter(rewrite);
            rewriter2.rewriteProgramHopDAGs(prog);
            dmlt.constructLops(prog);
            rtprog = dmlt.getRuntimeProgram(prog, this._dmlconf);
            JMLCUtils.cleanupRuntimeProgram(rtprog, outputs);
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception ex) {
            throw new DMLException(ex);
        }
        return new PreparedScript(rtprog, inputs, outputs, this._dmlconf, this._cconf);
    }

    @Override
    public void close() {
        ConfigurationManager.clearLocalConfigs();
        if (ConfigurationManager.isCodegenEnabled()) {
            SpoofCompiler.cleanupCodeGenerator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readScript(String fname) throws IOException {
        BufferedReader in;
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            in = null;
            try {
                if (fname.startsWith("hdfs:") || fname.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(fname))) {
                    Path scriptPath = new Path(fname);
                    fs = IOUtilFunctions.getFileSystem(scriptPath);
                    in = new BufferedReader(new InputStreamReader((InputStream)fs.open(scriptPath)));
                } else {
                    in = new BufferedReader(new FileReader(fname));
                }
                String tmp = null;
                while ((tmp = in.readLine()) != null) {
                    sb.append(tmp);
                    sb.append("\n");
                }
                if (fs == null) break block6;
            }
            catch (Throwable throwable) {
                if (fs != null) {
                    fs.close();
                }
                IOUtilFunctions.closeSilently(in);
                throw throwable;
            }
            fs.close();
        }
        IOUtilFunctions.closeSilently(in);
        return sb.toString();
    }

    public double[][] readDoubleMatrix(String fname) throws IOException {
        try {
            String fnamemtd = DataExpression.getMTDFileName(fname);
            MetaDataAll metaObj = new MetaDataAll(fnamemtd, false, true);
            long rows = metaObj.getDim1();
            long cols = metaObj.getDim2();
            int blen = metaObj.getBlocksize();
            long nnz = metaObj.getNnz();
            Types.FileFormat fmt = metaObj.getFileFormat();
            return this.readDoubleMatrix(fname, fmt, rows, cols, blen, nnz);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public double[][] readDoubleMatrix(String fname, Types.FileFormat fmt, long rows, long cols, int blen, long nnz) throws IOException {
        this.setLocalConfigs();
        try {
            MatrixReader reader = MatrixReaderFactory.createMatrixReader(fmt);
            MatrixBlock mb = reader.readMatrixFromHDFS(fname, rows, cols, blen, nnz);
            return DataConverter.convertToDoubleMatrix(mb);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public double[][] convertToDoubleMatrix(String input, String meta) throws IOException {
        MatrixBlock mb = this.convertToMatrix(input, meta);
        return DataConverter.convertToDoubleMatrix(mb);
    }

    public double[][] convertToDoubleMatrix(String input, int rows, int cols) throws IOException {
        try (InputStream is = IOUtilFunctions.toInputStream(input);){
            double[][] dArray = this.convertToDoubleMatrix(is, rows, cols);
            return dArray;
        }
    }

    public double[][] convertToDoubleMatrix(InputStream input, int rows, int cols) throws IOException {
        return this.convertToDoubleMatrix(input, rows, cols, Types.FileFormat.defaultFormatString());
    }

    public double[][] convertToDoubleMatrix(InputStream input, int rows, int cols, String format) throws IOException {
        MatrixBlock mb = this.convertToMatrix(input, rows, cols, format);
        return DataConverter.convertToDoubleMatrix(mb);
    }

    public MatrixBlock convertToMatrix(String input, String meta) throws IOException {
        try (InputStream is = IOUtilFunctions.toInputStream(input);){
            MatrixBlock matrixBlock = this.convertToMatrix(is, meta);
            return matrixBlock;
        }
    }

    public MatrixBlock convertToMatrix(InputStream input, String meta) throws IOException {
        try {
            MetaDataAll mtd = new MetaDataAll(meta);
            int rows = (int)mtd.getDim1();
            int cols = (int)mtd.getDim2();
            String format = mtd.getFormatTypeString();
            return this.convertToMatrix(input, rows, cols, format);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public MatrixBlock convertToMatrix(String input, int rows, int cols) throws IOException {
        try (InputStream is = IOUtilFunctions.toInputStream(input);){
            MatrixBlock matrixBlock = this.convertToMatrix(is, rows, cols);
            return matrixBlock;
        }
    }

    public MatrixBlock convertToMatrix(InputStream input, int rows, int cols) throws IOException {
        return this.convertToMatrix(input, rows, cols, Types.FileFormat.defaultFormatString());
    }

    public MatrixBlock convertToMatrix(InputStream input, int rows, int cols, String format) throws IOException {
        MatrixBlock ret = null;
        if (!(Types.FileFormat.TEXT.toString().equals(format) || Types.FileFormat.MM.toString().equals(format) || Types.FileFormat.CSV.toString().equals(format))) {
            throw new IOException("Invalid input format (expected: csv, text or mm): " + format);
        }
        this.setLocalConfigs();
        try {
            Types.FileFormat fmt = Types.FileFormat.safeValueOf(format);
            MatrixReader reader = MatrixReaderFactory.createMatrixReader(fmt);
            int blksz = ConfigurationManager.getBlocksize();
            ret = reader.readMatrixFromInputStream(input, rows, cols, blksz, (long)rows * (long)cols);
        }
        catch (DMLRuntimeException rex) {
            throw new IOException(rex);
        }
        return ret;
    }

    public String[][] readStringFrame(String fname) throws IOException {
        try {
            String fnamemtd = DataExpression.getMTDFileName(fname);
            MetaDataAll metaObj = new MetaDataAll(fnamemtd, false, true);
            long rows = metaObj.getDim1();
            long cols = metaObj.getDim2();
            Types.FileFormat fmt = metaObj.getFileFormat();
            return this.readStringFrame(fname, fmt, rows, cols);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String[][] readStringFrame(String fname, Types.FileFormat fmt, long rows, long cols) throws IOException {
        this.setLocalConfigs();
        try {
            FrameReader reader = FrameReaderFactory.createFrameReader(fmt);
            FrameBlock mb = reader.readFrameFromHDFS(fname, rows, cols);
            return DataConverter.convertToStringFrame(mb);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String[][] convertToStringFrame(String input, String meta) throws IOException {
        FrameBlock fb = this.convertToFrame(input, meta);
        return DataConverter.convertToStringFrame(fb);
    }

    public String[][] convertToStringFrame(String input, int rows, int cols) throws IOException {
        try (InputStream is = IOUtilFunctions.toInputStream(input);){
            String[][] stringArray = this.convertToStringFrame(is, rows, cols);
            return stringArray;
        }
    }

    public String[][] convertToStringFrame(InputStream input, int rows, int cols) throws IOException {
        return this.convertToStringFrame(input, rows, cols, Types.FileFormat.defaultFormatString());
    }

    public String[][] convertToStringFrame(InputStream input, int rows, int cols, String format) throws IOException {
        FrameBlock fb = this.convertToFrame(input, rows, cols, format);
        return DataConverter.convertToStringFrame(fb);
    }

    public FrameBlock convertToFrame(String input, String meta) throws IOException {
        try (InputStream is = IOUtilFunctions.toInputStream(input);){
            FrameBlock frameBlock = this.convertToFrame(is, meta);
            return frameBlock;
        }
    }

    public FrameBlock convertToFrame(InputStream input, String meta) throws IOException {
        try {
            MetaDataAll mtd = new MetaDataAll(meta);
            int rows = (int)mtd.getDim1();
            int cols = (int)mtd.getDim2();
            String format = mtd.getFormatTypeString();
            return this.convertToFrame(input, rows, cols, format);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public FrameBlock convertToFrame(String input, int rows, int cols) throws IOException {
        try (InputStream is = IOUtilFunctions.toInputStream(input);){
            FrameBlock frameBlock = this.convertToFrame(is, rows, cols);
            return frameBlock;
        }
    }

    public FrameBlock convertToFrame(InputStream input, int rows, int cols) throws IOException {
        return this.convertToFrame(input, rows, cols, Types.FileFormat.TEXT.toString());
    }

    public FrameBlock convertToFrame(InputStream input, int rows, int cols, String format) throws IOException {
        FrameBlock ret = null;
        if (!(Types.FileFormat.TEXT.toString().equals(format) || Types.FileFormat.MM.toString().equals(format) || Types.FileFormat.CSV.toString().equals(format))) {
            throw new IOException("Invalid input format (expected: csv, text or mm): " + format);
        }
        this.setLocalConfigs();
        try {
            Types.FileFormat fmt = Types.FileFormat.safeValueOf(format);
            FrameReader reader = FrameReaderFactory.createFrameReader(fmt);
            ret = reader.readFrameFromInputStream(input, rows, cols);
        }
        catch (DMLRuntimeException rex) {
            throw new IOException(rex);
        }
        return ret;
    }

    public FrameBlock readTransformMetaDataFromFile(String metapath) throws IOException {
        return this.readTransformMetaDataFromFile(null, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromFile(String spec, String metapath) throws IOException {
        return this.readTransformMetaDataFromFile(spec, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromFile(String spec, String metapath, String colDelim) throws IOException {
        return TfMetaUtils.readTransformMetaDataFromFile(spec, metapath, colDelim);
    }

    public FrameBlock readTransformMetaDataFromPath(String metapath) throws IOException {
        return this.readTransformMetaDataFromPath(null, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromPath(String spec, String metapath) throws IOException {
        return this.readTransformMetaDataFromPath(spec, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromPath(String spec, String metapath, String colDelim) throws IOException {
        return TfMetaUtils.readTransformMetaDataFromPath(spec, metapath, colDelim);
    }

    private void setLocalConfigs() {
        ConfigurationManager.setLocalConfig(this._dmlconf);
        ConfigurationManager.setLocalConfig(this._cconf);
    }
}

