/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.APreAgg;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictLibMatrixMult;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupUncompressed
extends AColGroup {
    private static final long serialVersionUID = -8254271148043292199L;
    private MatrixBlock _data;

    protected ColGroupUncompressed() {
    }

    private ColGroupUncompressed(MatrixBlock mb, int[] colIndexes) {
        super(colIndexes);
        this._data = mb;
    }

    protected static AColGroup create(MatrixBlock mb, int[] colIndexes) {
        if (mb.isEmpty()) {
            return new ColGroupEmpty(colIndexes);
        }
        return new ColGroupUncompressed(mb, colIndexes);
    }

    public static AColGroup create(int[] colIndexes, MatrixBlock rawBlock, boolean transposed) {
        int _numRows;
        if (rawBlock.isEmptyBlock(false)) {
            return new ColGroupEmpty(colIndexes);
        }
        if (!transposed && colIndexes.length == rawBlock.getNumColumns()) {
            return new ColGroupUncompressed(rawBlock, colIndexes);
        }
        int n = _numRows = transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows();
        if (colIndexes.length == 1) {
            MatrixBlock mb;
            int col = colIndexes[0];
            if (transposed) {
                mb = rawBlock.slice(col, col, 0, rawBlock.getNumColumns() - 1);
                mb = LibMatrixReorg.transposeInPlace(mb, InfrastructureAnalyzer.getLocalParallelism());
            } else {
                mb = rawBlock.slice(0, rawBlock.getNumRows() - 1, col, col);
            }
            return ColGroupUncompressed.create(mb, colIndexes);
        }
        MatrixBlock mb = new MatrixBlock(_numRows, colIndexes.length, rawBlock.isInSparseFormat());
        int m = _numRows;
        int n2 = colIndexes.length;
        if (transposed) {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n2; ++j) {
                    mb.appendValue(i, j, rawBlock.quickGetValue(colIndexes[j], i));
                }
            }
        } else {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n2; ++j) {
                    mb.appendValue(i, j, rawBlock.quickGetValue(i, colIndexes[j]));
                }
            }
        }
        mb.recomputeNonZeros();
        mb.examSparsity();
        return ColGroupUncompressed.create(mb, colIndexes);
    }

    protected ColGroupUncompressed(int[] colIndices, MatrixBlock data) {
        super(colIndices);
        this._data = data;
        this._data.recomputeNonZeros();
    }

    public ColGroupUncompressed(MatrixBlock data) {
        super(Util.genColsIndices(data.getNumColumns()));
        this._data = data;
        this._data.recomputeNonZeros();
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.UNCOMPRESSED;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.UNCOMPRESSED;
    }

    public MatrixBlock getData() {
        return this._data;
    }

    @Override
    public long estimateInMemorySize() {
        return ColGroupSizes.estimateInMemorySizeUncompressed(this._data.getNumRows(), this.getNumCols(), this._data.getSparsity());
    }

    @Override
    public void decompressToDenseBlock(DenseBlock db, int rl, int ru, int offR, int offC) {
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            this.decompressToDenseBlockSparseData(db, rl, ru, offR, offC);
        } else {
            this.decompressToDenseBlockDenseData(db, rl, ru, offR, offC);
        }
    }

    private void decompressToDenseBlockDenseData(DenseBlock db, int rl, int ru, int offR, int offC) {
        int offT = rl + offR;
        int nCol = this._colIndexes.length;
        double[] values = this._data.getDenseBlockValues();
        int offS = rl * nCol;
        int row = rl;
        while (row < ru) {
            double[] c = db.values(offT);
            int off = db.pos(offT) + offC;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes[j];
                c[n] = c[n] + values[offS + j];
            }
            ++row;
            ++offT;
            offS += nCol;
        }
    }

    private void decompressToDenseBlockSparseData(DenseBlock db, int rl, int ru, int offR, int offC) {
        SparseBlock sb = this._data.getSparseBlock();
        int row = rl;
        int offT = rl + offR;
        while (row < ru) {
            if (!sb.isEmpty(row)) {
                double[] c = db.values(offT);
                int off = db.pos(offT) + offC;
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                for (int col = apos; col < alen; ++col) {
                    int n = this._colIndexes[aix[col]] + off;
                    c[n] = c[n] + avals[col];
                }
            }
            ++row;
            ++offT;
        }
    }

    @Override
    public void decompressToSparseBlock(SparseBlock ret, int rl, int ru, int offR, int offC) {
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            this.decompressToSparseBlockSparseData(ret, rl, ru, offR, offC);
        } else {
            this.decompressToSparseBlockDenseData(ret, rl, ru, offR, offC);
        }
    }

    private void decompressToSparseBlockDenseData(SparseBlock ret, int rl, int ru, int offR, int offC) {
        int nCol = this._colIndexes.length;
        double[] values = this._data.getDenseBlockValues();
        int offS = rl * nCol;
        int row = rl;
        int offT = rl + offR;
        while (row < ru) {
            for (int j = 0; j < nCol; ++j) {
                ret.append(offT, offC + this._colIndexes[j], values[offS + j]);
            }
            ++row;
            ++offT;
            offS += nCol;
        }
    }

    private void decompressToSparseBlockSparseData(SparseBlock ret, int rl, int ru, int offR, int offC) {
        int offT = rl + offR;
        SparseBlock sb = this._data.getSparseBlock();
        int row = rl;
        while (row < ru) {
            if (!sb.isEmpty(row)) {
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                for (int col = apos; col < alen; ++col) {
                    ret.append(offT, offC + this._colIndexes[aix[col]], avals[col]);
                }
            }
            ++row;
            ++offT;
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        return this._data.quickGetValue(r, colIdx);
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        int nCol = matrix.getNumColumns();
        int nColRet = result.getNumColumns();
        double[] retV = result.getDenseBlockValues();
        if (matrix.isInSparseFormat()) {
            this.lmmNPSparse(matrix.getSparseBlock(), nCol, retV, nColRet, rl, ru, cl, cu);
        } else {
            this.lmmNPDense(matrix.getDenseBlockValues(), nCol, retV, nColRet, rl, ru, cl, cu);
        }
    }

    protected void lmmNPSparse(SparseBlock sb, int nCol, double[] retV, int nColRet, int rl, int ru, int cl, int cu) {
        if (this._data.isInSparseFormat()) {
            SparseBlock dsb = this._data.getSparseBlock();
            for (int r = rl; r < ru; ++r) {
                if (sb.isEmpty(r)) continue;
                int aposL = sb.pos(r);
                int alenL = sb.size(r) + aposL;
                int[] aixL = sb.indexes(r);
                double[] avalL = sb.values(r);
                int offR = r * nColRet;
                for (int j = aposL; j < alenL; ++j) {
                    int c = aixL[j];
                    if (dsb.isEmpty(c)) continue;
                    double v = avalL[j];
                    int apos = dsb.pos(c);
                    int alen = dsb.size(c) + apos;
                    int[] aix = dsb.indexes(c);
                    double[] aval = dsb.values(c);
                    for (int i = apos; i < alen; ++i) {
                        int n = offR + this._colIndexes[aix[i]];
                        retV[n] = retV[n] + v * aval[i];
                    }
                }
            }
        } else {
            double[] dV = this._data.getDenseBlockValues();
            int nColD = this._colIndexes.length;
            for (int r = rl; r < ru; ++r) {
                if (sb.isEmpty(r)) continue;
                int aposL = sb.pos(r);
                int alenL = sb.size(r) + aposL;
                int[] aixL = sb.indexes(r);
                double[] avalL = sb.values(r);
                int offR = r * nColRet;
                for (int j = aposL; j < alenL; ++j) {
                    int c = aixL[j];
                    double v = avalL[j];
                    int offD = c * nColD;
                    for (int i = 0; i < nColD; ++i) {
                        int n = offR + this._colIndexes[i];
                        retV[n] = retV[n] + v * dV[offD + i];
                    }
                }
            }
        }
    }

    protected void lmmNPDense(double[] mV, int nCol, double[] retV, int nColRet, int rl, int ru, int cl, int cu) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int r = rl; r < ru; ++r) {
                int off = r * nCol;
                int offR = r * nColRet;
                for (int c = cl; c < cu; ++c) {
                    if (sb.isEmpty(c)) continue;
                    int apos = sb.pos(c);
                    int alen = sb.size(c) + apos;
                    int[] aix = sb.indexes(c);
                    double[] aval = sb.values(c);
                    double v = mV[off + c];
                    for (int i = apos; i < alen; ++i) {
                        int n = offR + this._colIndexes[aix[i]];
                        retV[n] = retV[n] + v * aval[i];
                    }
                }
            }
        } else {
            double[] dV = this._data.getDenseBlockValues();
            int nColD = this._colIndexes.length;
            for (int r = rl; r < ru; ++r) {
                int off = r * nCol;
                int offR = r * nColRet;
                for (int c = cl; c < cu; ++c) {
                    int offD = c * nColD;
                    double v = mV[off + c];
                    for (int i = 0; i < nColD; ++i) {
                        int n = offR + this._colIndexes[i];
                        retV[n] = retV[n] + v * dV[offD + i];
                    }
                }
            }
        }
    }

    public void leftMultByMatrix(MatrixBlock matrix, MatrixBlock result, int rl, int ru) {
        MatrixBlock tmpRet = new MatrixBlock(ru - rl, this._data.getNumColumns(), false);
        tmpRet.allocateDenseBlock();
        MatrixBlock leftSlice = matrix.slice(rl, ru - 1, false);
        LibMatrixMult.matrixMult(leftSlice, this._data, tmpRet);
        int offT = result.getNumColumns() * rl;
        double[] resV = result.getDenseBlockValues();
        if (tmpRet.isEmpty()) {
            return;
        }
        if (tmpRet.isInSparseFormat()) {
            SparseBlock sb = tmpRet.getSparseBlock();
            int rowIdx = 0;
            while (rowIdx < ru - rl) {
                if (!sb.isEmpty(rowIdx)) {
                    int apos = sb.pos(rowIdx);
                    int alen = sb.size(rowIdx) + apos;
                    int[] aix = sb.indexes(rowIdx);
                    double[] avals = sb.values(rowIdx);
                    for (int col = apos; col < alen; ++col) {
                        int n = offT + this._colIndexes[aix[col]];
                        resV[n] = resV[n] + avals[col];
                    }
                }
                ++rowIdx;
                offT += result.getNumColumns();
            }
        } else {
            double[] tmpRetV = tmpRet.getDenseBlockValues();
            int j = rl;
            int offTemp = 0;
            while (j < ru) {
                for (int i = 0; i < this._colIndexes.length; ++i) {
                    int n = offT + this._colIndexes[i];
                    resV[n] = resV[n] + tmpRetV[offTemp + i];
                }
                ++j;
                offTemp += this._colIndexes.length;
                offT += result.getNumColumns();
            }
        }
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        MatrixBlock retContent = this._data.scalarOperations(op, new MatrixBlock());
        return ColGroupUncompressed.create(retContent, this.getColIndices());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        MatrixBlock retContent = this._data.unaryOperations(op, new MatrixBlock());
        return ColGroupUncompressed.create(retContent, this.getColIndices());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        throw new NotImplementedException("Binary row op left is not supported for Uncompressed Matrix, Implement support for VMr in MatrixBlock Binary Cell operations");
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        MatrixBlock rowVector = Util.extractValues(v, this._colIndexes);
        return ColGroupUncompressed.create(this._data.binaryOperations(op, rowVector, null), this.getColIndices());
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, double[] result, int nRows, int rl, int ru) {
        if (op.aggOp.increOp.fn instanceof Multiply && op.indexFn instanceof ReduceAll && result[0] == 0.0) {
            return;
        }
        MatrixBlock tmpData = this._data.slice(rl, ru - 1, false);
        MatrixBlock tmp = tmpData.aggregateUnaryOperations(op, new MatrixBlock(), this._data.getNumRows(), new MatrixIndexes(1L, 1L), true);
        if (tmp.isEmpty()) {
            if (op.aggOp.increOp.fn instanceof Builtin) {
                Builtin b = (Builtin)op.aggOp.increOp.fn;
                if (op.indexFn instanceof ReduceRow) {
                    for (int i = 0; i < this._colIndexes.length; ++i) {
                        result[this._colIndexes[i]] = b.execute(result[this._colIndexes[i]], 0.0);
                    }
                } else if (op.indexFn instanceof ReduceAll) {
                    result[0] = b.execute(result[0], 0.0);
                } else {
                    for (int row = rl; row < ru; ++row) {
                        result[row] = b.execute(result[row], 0.0);
                    }
                }
            }
            return;
        }
        tmp.sparseToDense();
        double[] tmpV = tmp.getDenseBlockValues();
        if (op.aggOp.increOp.fn instanceof Builtin) {
            Builtin b = (Builtin)op.aggOp.increOp.fn;
            if (op.indexFn instanceof ReduceRow) {
                for (int i = 0; i < tmpV.length; ++i) {
                    result[this._colIndexes[i]] = b.execute(result[this._colIndexes[i]], tmpV[i]);
                }
            } else if (op.indexFn instanceof ReduceAll) {
                result[0] = b.execute(result[0], tmpV[0]);
            } else {
                int i = 0;
                int row = rl;
                while (i < tmpV.length) {
                    result[row] = b.execute(result[row], tmpV[i]);
                    ++i;
                    ++row;
                }
            }
        } else if (op.aggOp.increOp.fn instanceof Multiply) {
            if (op.indexFn instanceof ReduceRow) {
                for (int i = 0; i < tmpV.length; ++i) {
                    int n = this._colIndexes[i];
                    result[n] = result[n] * tmpV[i];
                }
            } else if (op.indexFn instanceof ReduceAll) {
                result[0] = result[0] * tmpV[0];
            } else {
                int row = rl;
                for (int i = 0; i < tmpV.length; ++i) {
                    int n = row++;
                    result[n] = result[n] * tmpV[i];
                }
            }
        } else if (op.indexFn instanceof ReduceRow) {
            for (int i = 0; i < tmpV.length; ++i) {
                int n = this._colIndexes[i];
                result[n] = result[n] + tmpV[i];
            }
        } else if (op.indexFn instanceof ReduceAll) {
            result[0] = result[0] + tmpV[0];
        } else {
            int row = rl;
            for (int i = 0; i < tmpV.length; ++i) {
                int n = row++;
                result[n] = result[n] + tmpV[i];
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._data = new MatrixBlock();
        this._data.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._data.write(out);
    }

    @Override
    public long getExactSizeOnDisk() {
        return super.getExactSizeOnDisk() + this._data.getExactSizeOnDisk();
    }

    @Override
    public double getMin() {
        return this._data.min();
    }

    @Override
    public double getMax() {
        return this._data.max();
    }

    @Override
    public final void tsmm(MatrixBlock ret, int nRows) {
        if (this._data.isEmpty()) {
            return;
        }
        int tCol = this._colIndexes.length;
        MatrixBlock tmp = new MatrixBlock(tCol, tCol, true);
        LibMatrixMult.matrixMultTransposeSelf(this._data, tmp, true, false);
        int numColumns = ret.getNumColumns();
        double[] result = ret.getDenseBlockValues();
        double[] tmpV = tmp.getDenseBlockValues();
        int row = 0;
        int offTmp = 0;
        while (row < tCol) {
            int offRet = this._colIndexes[row] * numColumns;
            for (int col = row; col < tCol; ++col) {
                int n = offRet + this._colIndexes[col];
                result[n] = result[n] + tmpV[offTmp + col];
            }
            ++row;
            offTmp += tCol;
        }
    }

    @Override
    public AColGroup copy() {
        return ColGroupUncompressed.create(this._data, this._colIndexes);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._data.containsValue(pattern);
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        return this._data.getNonZeros();
    }

    @Override
    public void leftMultByAColGroup(AColGroup lhs, MatrixBlock result) {
        if (lhs instanceof ColGroupEmpty || this.getData().isEmpty()) {
            return;
        }
        if (lhs instanceof ColGroupUncompressed) {
            ColGroupUncompressed lhsUC = (ColGroupUncompressed)lhs;
            MatrixBlock tmpRet = new MatrixBlock(lhs.getNumCols(), this._colIndexes.length, 0L);
            if (lhsUC._data == this._data) {
                LibMatrixMult.matrixMultTransposeSelf(this._data, tmpRet, true, InfrastructureAnalyzer.getLocalParallelism());
            } else {
                LOG.warn((Object)"Inefficient Left Matrix Multiplication with transpose of left hand side : t(l) %*% r");
                MatrixBlock lhData = lhsUC._data;
                MatrixBlock transposed = LibMatrixReorg.transpose(lhData, InfrastructureAnalyzer.getLocalParallelism());
                transposed.setNonZeros(lhData.getNonZeros());
                LibMatrixMult.matrixMult(transposed, this._data, tmpRet);
            }
            double[] resV = result.getDenseBlockValues();
            if (tmpRet.isEmpty()) {
                return;
            }
            if (tmpRet.isInSparseFormat()) {
                SparseBlock sb = tmpRet.getSparseBlock();
                for (int row = 0; row < lhs._colIndexes.length; ++row) {
                    if (sb.isEmpty(row)) continue;
                    int apos = sb.pos(row);
                    int alen = sb.size(row) + apos;
                    int[] aix = sb.indexes(row);
                    double[] avals = sb.values(row);
                    int offRes = lhs._colIndexes[row] * result.getNumColumns();
                    for (int col = apos; col < alen; ++col) {
                        int n = offRes + this._colIndexes[aix[col]];
                        resV[n] = resV[n] + avals[col];
                    }
                }
            } else {
                double[] tmpRetV = tmpRet.getDenseBlockValues();
                for (int row = 0; row < lhs._colIndexes.length; ++row) {
                    int offRes = lhs._colIndexes[row] * result.getNumColumns();
                    int offTmp = lhs._colIndexes.length * row;
                    for (int col = 0; col < this._colIndexes.length; ++col) {
                        int n = offRes + this._colIndexes[col];
                        resV[n] = resV[n] + tmpRetV[offTmp + col];
                    }
                }
            }
        } else if (lhs instanceof APreAgg) {
            LOG.warn((Object)"\nInefficient transpose of uncompressed to fit to t(AColGroup) %*% UncompressedColGroup mult by colGroup uncompressed column\nCurrently solved by t(t(Uncompressed) %*% AColGroup)");
            MatrixBlock ucCGT = LibMatrixReorg.transpose(this.getData(), InfrastructureAnalyzer.getLocalParallelism());
            APreAgg paCG = (APreAgg)lhs;
            MatrixBlock preAgg = new MatrixBlock(1, lhs.getNumValues(), false);
            MatrixBlock tmpRes = new MatrixBlock(1, this.getNumCols(), false);
            MatrixBlock dictM = paCG._dict.getMBDict(paCG.getNumCols()).getMatrixBlock();
            preAgg.allocateDenseBlock();
            tmpRes.allocateDenseBlock();
            int nRows = ucCGT.getNumRows();
            int nCols = lhs.getNumCols();
            double[] retV = result.getDenseBlockValues();
            double[] tmpV = tmpRes.getDenseBlockValues();
            int retCols = result.getNumColumns();
            for (int i = 0; i < nRows; ++i) {
                if (ucCGT.isInSparseFormat() && ucCGT.getSparseBlock().isEmpty(i)) continue;
                paCG.preAggregate(ucCGT, preAgg.getDenseBlockValues(), i, i + 1);
                preAgg.recomputeNonZeros();
                LibMatrixMult.matrixMult(preAgg, dictM, tmpRes, true);
                int rowOut = this._colIndexes[i];
                for (int j = 0; j < nCols; ++j) {
                    int colOut = lhs._colIndexes[j] * retCols;
                    int n = rowOut + colOut;
                    retV[n] = retV[n] + tmpV[j];
                }
                if (i >= nRows - 1) continue;
                preAgg.reset(1, lhs.getNumValues());
                tmpRes.reset(1, this.getNumCols());
            }
        } else {
            throw new NotImplementedException();
        }
    }

    @Override
    public void tsmmAColGroup(AColGroup lhs, MatrixBlock result) {
        if (this._data.isEmpty()) {
            return;
        }
        if (lhs instanceof ColGroupUncompressed) {
            ColGroupUncompressed lhsUC = (ColGroupUncompressed)lhs;
            if (lhsUC._data.isEmpty()) {
                return;
            }
            MatrixBlock tmpRet = new MatrixBlock(lhs.getNumCols(), this._colIndexes.length, 0L);
            if (lhsUC._data == this._data) {
                LibMatrixMult.matrixMultTransposeSelf(this._data, tmpRet, true, InfrastructureAnalyzer.getLocalParallelism());
            } else {
                LOG.warn((Object)"Inefficient Left Matrix Multiplication with transpose of left hand side : t(l) %*% r");
                MatrixBlock lhData = lhsUC._data;
                MatrixBlock transposed = LibMatrixReorg.transpose(lhData, InfrastructureAnalyzer.getLocalParallelism());
                transposed.setNonZeros(lhData.getNonZeros());
                LibMatrixMult.matrixMult(transposed, this._data, tmpRet);
            }
            double[] resV = result.getDenseBlockValues();
            int nCols = result.getNumColumns();
            if (tmpRet.isEmpty()) {
                return;
            }
            if (tmpRet.isInSparseFormat()) {
                SparseBlock sb = tmpRet.getSparseBlock();
                for (int row = 0; row < lhs._colIndexes.length; ++row) {
                    if (sb.isEmpty(row)) continue;
                    int apos = sb.pos(row);
                    int alen = sb.size(row) + apos;
                    int[] aix = sb.indexes(row);
                    double[] avals = sb.values(row);
                    for (int col = apos; col < alen; ++col) {
                        DictLibMatrixMult.addToUpperTriangle(nCols, lhs._colIndexes[row], this._colIndexes[aix[col]], resV, avals[col]);
                    }
                }
            } else {
                double[] tmpRetV = tmpRet.getDenseBlockValues();
                for (int row = 0; row < lhs._colIndexes.length; ++row) {
                    int offTmp = lhs._colIndexes.length * row;
                    for (int col = 0; col < this._colIndexes.length; ++col) {
                        DictLibMatrixMult.addToUpperTriangle(nCols, lhs._colIndexes[row], this._colIndexes[col], resV, tmpRetV[offTmp + col]);
                    }
                }
            }
        } else {
            lhs.tsmmAColGroup(this, result);
        }
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        return this.sliceMultiColumns(idx, idx + 1, new int[]{0});
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, int[] outputCols) {
        MatrixBlock newData = this._data.slice(0, this._data.getNumRows() - 1, idStart, idEnd - 1, true);
        return ColGroupUncompressed.create(newData, outputCols);
    }

    @Override
    public AColGroup rightMultByMatrix(MatrixBlock right) {
        MatrixBlock subBlockRight;
        int nColR = right.getNumColumns();
        int[] outputCols = Util.genColsIndices(nColR);
        if (this._data.isEmpty() || right.isEmpty()) {
            return new ColGroupEmpty(outputCols);
        }
        if (right.isInSparseFormat()) {
            subBlockRight = new MatrixBlock(this._data.getNumColumns(), nColR, true);
            subBlockRight.allocateSparseRowsBlock();
            SparseBlock sbR = right.getSparseBlock();
            SparseBlock subR = subBlockRight.getSparseBlock();
            long nnz = 0L;
            for (int i = 0; i < this._colIndexes.length; ++i) {
                if (sbR.isEmpty(this._colIndexes[i])) continue;
                subR.set(i, sbR.get(this._colIndexes[i]), false);
                nnz += (long)sbR.get(this._colIndexes[i]).size();
            }
            subBlockRight.setNonZeros(nnz);
        } else {
            subBlockRight = new MatrixBlock(this._data.getNumColumns(), nColR, false);
            subBlockRight.allocateDenseBlock();
            double[] sbr = subBlockRight.getDenseBlockValues();
            double[] rightV = right.getDenseBlockValues();
            for (int i = 0; i < this._colIndexes.length; ++i) {
                int offSubBlock = i * nColR;
                int offRight = this._colIndexes[i] * nColR;
                System.arraycopy(rightV, offRight, sbr, offSubBlock, nColR);
            }
            subBlockRight.setNonZeros(this._data.getNumColumns() * nColR);
        }
        MatrixBlock out = new MatrixBlock(this._data.getNumRows(), nColR, false);
        LibMatrixMult.matrixMult(this._data, subBlockRight, out, InfrastructureAnalyzer.getLocalParallelism());
        return ColGroupUncompressed.create(out, outputCols);
    }

    @Override
    public int getNumValues() {
        return this._data.getNumRows();
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        MatrixBlock replaced = this._data.replaceOperations(new MatrixBlock(), pattern, replace);
        return ColGroupUncompressed.create(replaced, this._colIndexes);
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
        MatrixBlock colSum = this._data.colSum();
        if (colSum.isEmpty()) {
            return;
        }
        if (colSum.isInSparseFormat()) {
            SparseBlock sb = colSum.getSparseBlock();
            double[] rv = sb.values(0);
            int[] idx = sb.indexes(0);
            for (int i = 0; i < idx.length; ++i) {
                int n = this._colIndexes[idx[i]];
                c[n] = c[n] + rv[i];
            }
        } else {
            double[] dv = colSum.getDenseBlockValues();
            for (int i = 0; i < this._colIndexes.length; ++i) {
                int n = this._colIndexes[i];
                c[n] = c[n] + dv[i];
            }
        }
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        return this._data.cmOperations(op);
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        MatrixBlock nd = LibMatrixReorg.rexpand(this._data, new MatrixBlock(), max, false, cast, ignore, 1);
        return ColGroupUncompressed.create(nd, Util.genColsIndices(max));
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        return e.getCost(nRows, nRows, nCols, nVals, this._data.getSparsity());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\n");
        sb.append(" numCols : " + this._data.getNumColumns());
        sb.append(" numRows : " + this._data.getNumRows());
        sb.append(" nonZeros: " + this._data.getNonZeros());
        sb.append(" Sparse : " + this._data.isInSparseFormat());
        if (this._data.isEmpty()) {
            sb.append(" empty");
            return sb.toString();
        }
        sb.append("\n");
        if (!this._data.isInSparseFormat() && this._data.getNumRows() < 1000) {
            sb.append(Arrays.toString(this._data.getDenseBlockValues()));
        } else if (this._data.getNumRows() < 100) {
            sb.append(this._data.toString());
        } else {
            sb.append(" don't print uncompressed matrix because it is to big.");
        }
        return sb.toString();
    }
}

