/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.insertionsort;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.MaterializeSort;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.MergeSort;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public interface InsertionSorterFactory {
    public static final Log LOG = LogFactory.getLog((String)InsertionSorterFactory.class.getName());

    public static AInsertionSorter create(int numRows, IntArrayList[] offsets, SORT_TYPE st) {
        return InsertionSorterFactory.create(InsertionSorterFactory.getEndLength(offsets), numRows, offsets, st);
    }

    public static AInsertionSorter create(int endLength, int numRows, IntArrayList[] offsets, SORT_TYPE st) {
        switch (st) {
            case MERGE: {
                return new MergeSort(endLength, numRows, offsets);
            }
        }
        return new MaterializeSort(endLength, numRows, offsets);
    }

    public static AInsertionSorter createNegative(int numRows, IntArrayList[] offsets, int negativeIndex, SORT_TYPE st) {
        return InsertionSorterFactory.createNegative(numRows - offsets[negativeIndex].size(), numRows, offsets, negativeIndex, st);
    }

    public static AInsertionSorter createNegative(int endLength, int numRows, IntArrayList[] offsets, int negativeIndex, SORT_TYPE st) {
        switch (st) {
            case MERGE: {
                return new MergeSort(endLength, numRows, offsets, negativeIndex);
            }
        }
        return new MaterializeSort(endLength, numRows, offsets, negativeIndex);
    }

    private static int getEndLength(IntArrayList[] offsets) {
        int endLength = 0;
        for (IntArrayList l : offsets) {
            endLength += l.size();
        }
        return endLength;
    }

    public static enum SORT_TYPE {
        MERGE,
        MATERIALIZE;

    }
}

