/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetChar
extends AOffset {
    private static final long serialVersionUID = -1192266421395964882L;
    private static final int maxV = 65535;
    private final char[] offsets;
    private final int offsetToFirst;
    private final int offsetToLast;
    private final boolean noZero;

    public OffsetChar(int[] indexes) {
        this(indexes, 0, indexes.length);
    }

    public OffsetChar(int[] indexes, int apos, int alen) {
        int endSize = 0;
        this.offsetToFirst = indexes[apos];
        this.offsetToLast = indexes[alen - 1];
        int ov = this.offsetToFirst;
        for (int i = apos + 1; i < alen; ++i) {
            int nv = indexes[i];
            endSize += 1 + (nv - ov - 1) / 65535;
            ov = nv;
        }
        this.noZero = endSize == alen - apos - 1;
        this.offsets = new char[endSize];
        ov = this.offsetToFirst;
        int p = 0;
        for (int i = apos + 1; i < alen; ++i) {
            int nv = indexes[i];
            int offsetSize = nv - ov;
            int div = offsetSize / 65535;
            int mod = offsetSize % 65535;
            if (mod == 0) {
                p += div - 1;
                this.offsets[p++] = 65535;
            } else {
                p += div;
                this.offsets[p++] = (char)mod;
            }
            ov = nv;
        }
    }

    private OffsetChar(char[] offsets, int offsetToFirst, int offsetToLast) {
        this.offsets = offsets;
        this.offsetToFirst = offsetToFirst;
        this.offsetToLast = offsetToLast;
        this.noZero = this.getNoZero();
    }

    private boolean getNoZero() {
        boolean noZero = true;
        for (char b : this.offsets) {
            if (b != '\u0000') continue;
            noZero = false;
            break;
        }
        return noZero;
    }

    @Override
    public AIterator getIterator() {
        if (this.noZero) {
            return new IterateCharOffsetNoZero();
        }
        return new IterateCharOffset();
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        if (this.noZero) {
            return new OffsetCharIteratorNoZero();
        }
        return new OffsetCharIterator();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(OffsetFactory.OFF_TYPE.CHAR.ordinal());
        out.writeInt(this.offsetToFirst);
        out.writeInt(this.offsets.length);
        out.writeInt(this.offsetToLast);
        for (char o : this.offsets) {
            out.writeChar(o);
        }
    }

    @Override
    public long getInMemorySize() {
        return OffsetChar.estimateInMemorySize(this.offsets.length);
    }

    public static long estimateInMemorySize(int nOffs) {
        long size = 32L;
        return size += MemoryEstimates.charArrayCost(nOffs);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13 + this.offsets.length * 2;
    }

    @Override
    public int getSize() {
        if (this.noZero) {
            return this.offsets.length + 1;
        }
        int size = 1;
        for (char b : this.offsets) {
            if (b == '\u0000') continue;
            ++size;
        }
        return size;
    }

    @Override
    public int getOffsetToFirst() {
        return this.offsetToFirst;
    }

    @Override
    public int getOffsetToLast() {
        return this.offsetToLast;
    }

    @Override
    public int getOffsetsLength() {
        return this.offsets.length;
    }

    public static OffsetChar readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        int offsetToLast = in.readInt();
        char[] offsets = new char[offsetsLength];
        for (int i = 0; i < offsetsLength; ++i) {
            offsets[i] = in.readChar();
        }
        return new OffsetChar(offsets, offsetToFirst, offsetToLast);
    }

    private class OffsetCharIteratorNoZero
    extends AOffsetIterator {
        protected int index;

        private OffsetCharIteratorNoZero() {
            super(OffsetChar.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            char v = OffsetChar.this.offsets[this.index];
            ++this.index;
            return this.offset += v;
        }
    }

    private class OffsetCharIterator
    extends AOffsetIterator {
        protected int index;

        private OffsetCharIterator() {
            super(OffsetChar.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            char v = OffsetChar.this.offsets[this.index];
            while (v == '\u0000') {
                this.offset += 65535;
                ++this.index;
                v = OffsetChar.this.offsets[this.index];
            }
            ++this.index;
            return this.offset += v;
        }
    }

    private class IterateCharOffsetNoZero
    extends AIterator {
        protected int index;

        private IterateCharOffsetNoZero() {
            super(OffsetChar.this.offsetToFirst);
            this.index = 0;
        }

        private IterateCharOffsetNoZero(int index, int offset) {
            super(offset);
            this.index = index;
        }

        @Override
        public int next() {
            char v = OffsetChar.this.offsets[this.index];
            while (v == '\u0000') {
                this.offset += 65535;
                ++this.index;
                v = OffsetChar.this.offsets[this.index];
            }
            this.offset += v;
            ++this.index;
            return this.offset;
        }

        @Override
        public int value() {
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetChar.this.offsets.length) {
                this.next();
            }
            return this.offset;
        }

        @Override
        public IterateCharOffsetNoZero clone() {
            return new IterateCharOffsetNoZero(this.index, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.index;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }

    private class IterateCharOffset
    extends AIterator {
        protected int index;
        protected int dataIndex;

        private IterateCharOffset() {
            super(OffsetChar.this.offsetToFirst);
            this.index = 0;
            this.dataIndex = 0;
        }

        private IterateCharOffset(int index, int dataIndex, int offset) {
            super(offset);
            this.index = index;
            this.dataIndex = dataIndex;
        }

        @Override
        public int next() {
            char v = OffsetChar.this.offsets[this.index];
            while (v == '\u0000') {
                this.offset += 65535;
                ++this.index;
                v = OffsetChar.this.offsets[this.index];
            }
            this.offset += v;
            ++this.index;
            ++this.dataIndex;
            return this.offset;
        }

        @Override
        public int value() {
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetChar.this.offsets.length) {
                this.next();
            }
            return this.offset;
        }

        @Override
        public IterateCharOffset clone() {
            return new IterateCharOffset(this.index, this.dataIndex, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.dataIndex;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }
}

