/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedSizeEstimatorExact
extends CompressedSizeEstimator {
    public CompressedSizeEstimatorExact(MatrixBlock data, CompressionSettings compSettings) {
        super(data, compSettings);
    }

    @Override
    public CompressedSizeInfoColGroup getColGroupInfo(int[] colIndexes, int estimate, int nrUniqueUpperBound) {
        IEncode map = IEncode.createFromMatrixBlock(this._data, this._cs.transposed, colIndexes);
        if (map instanceof EmptyEncoding) {
            return new CompressedSizeInfoColGroup(colIndexes, this.getNumRows());
        }
        return this.getFacts(map, colIndexes);
    }

    @Override
    public CompressedSizeInfoColGroup getDeltaColGroupInfo(int[] colIndexes, int estimate, int nrUniqueUpperBound) {
        IEncode map = IEncode.createFromMatrixBlockDelta(this._data, this._cs.transposed, colIndexes);
        return this.getFacts(map, colIndexes);
    }

    @Override
    protected CompressedSizeInfoColGroup combine(int[] combinedColumns, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2, int maxDistinct) {
        IEncode map = g1.getMap().combine(g2.getMap());
        return this.getFacts(map, combinedColumns);
    }

    private CompressedSizeInfoColGroup getFacts(IEncode map, int[] colIndexes) {
        int _numRows = this.getNumRows();
        EstimationFactors em = map.extractFacts(colIndexes, _numRows, this._data.getSparsity(), this._data.getSparsity());
        return new CompressedSizeInfoColGroup(colIndexes, em, this._cs.validCompressions, map);
    }

    @Override
    protected int worstCaseUpperBound(int[] columns) {
        return this.getNumRows();
    }
}

