/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.SimpleOperator;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.utils.GPUStatistics;

public class MatrixIndexingGPUInstruction
extends GPUInstruction {
    CPOperand rowLower;
    CPOperand rowUpper;
    CPOperand colLower;
    CPOperand colUpper;

    private MatrixIndexingGPUInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(null, in, null, out, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.MatrixIndexing;
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
    }

    private MatrixIndexingGPUInstruction(Operator op, CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(op, lhsInput, rhsInput, out, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.MatrixIndexing;
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
    }

    public static MatrixIndexingGPUInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("rightIndex")) {
            if (parts.length == 7) {
                CPOperand in = new CPOperand(parts[1]);
                CPOperand rl = new CPOperand(parts[2]);
                CPOperand ru = new CPOperand(parts[3]);
                CPOperand cl = new CPOperand(parts[4]);
                CPOperand cu = new CPOperand(parts[5]);
                CPOperand out = new CPOperand(parts[6]);
                if (in.getDataType() == Types.DataType.MATRIX) {
                    return new MatrixIndexingGPUInstruction(in, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on Matrices in GPU");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        if (opcode.equalsIgnoreCase("leftIndex")) {
            if (parts.length == 8) {
                CPOperand lhsInput = new CPOperand();
                CPOperand rhsInput = new CPOperand();
                CPOperand rl = new CPOperand();
                CPOperand ru = new CPOperand();
                CPOperand cl = new CPOperand();
                CPOperand cu = new CPOperand();
                CPOperand out = new CPOperand();
                lhsInput.split(parts[1]);
                rhsInput.split(parts[2]);
                rl.split(parts[3]);
                ru.split(parts[4]);
                cl.split(parts[5]);
                cu.split(parts[6]);
                out.split(parts[7]);
                if (lhsInput.getDataType() == Types.DataType.MATRIX) {
                    return new MatrixIndexingGPUInstruction(new SimpleOperator(null), lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on Matrices in GPU");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a MatrixIndexingGPUInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec);
        if (!opcode.equalsIgnoreCase("rightIndex")) {
            throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
        }
        MatrixObject mat1 = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        LibMatrixCUDA.sliceOperations(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat1, ixrange, this._output.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }

    IndexRange getIndexRange(ExecutionContext ec) {
        return new IndexRange((int)(ec.getScalarInput(this.rowLower).getLongValue() - 1L), (int)(ec.getScalarInput(this.rowUpper).getLongValue() - 1L), (int)(ec.getScalarInput(this.colLower).getLongValue() - 1L), (int)(ec.getScalarInput(this.colUpper).getLongValue() - 1L));
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return Pair.of((Object)this._output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this._input1, this.rowLower, this.rowUpper, this.colLower, this.colUpper)));
    }
}

