/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.Utils;

public class H5BTree {
    private static final byte[] BTREE_NODE_SIGNATURE = "TREE".getBytes(StandardCharsets.US_ASCII);
    private static final int HEADER_BYTES = 6;
    private final long address;
    protected final int entriesUsed;
    private final long leftSiblingAddress;
    private final long rightSiblingAddress;
    private byte nodeType;
    private byte nodeLevel;
    private final List<Long> childAddresses;
    private final H5RootObject rootObject;

    public H5BTree(H5RootObject rootObject, byte nodeType, byte nodeLevel, int entriesUsed, long leftSiblingAddress, long rightSiblingAddress, List<Long> childAddresses) {
        this.address = 0L;
        this.rootObject = rootObject;
        this.nodeType = nodeType;
        this.nodeLevel = nodeLevel;
        this.entriesUsed = entriesUsed;
        this.leftSiblingAddress = leftSiblingAddress;
        this.rightSiblingAddress = rightSiblingAddress;
        this.childAddresses = childAddresses;
    }

    public H5BTree(H5RootObject rootObject, long address) {
        this.address = address;
        this.rootObject = rootObject;
        H5BTree.readHeaderAndValidateSignature(rootObject, address);
        int headerSize = 8 * rootObject.getSuperblock().sizeOfOffsets;
        ByteBuffer header = rootObject.readBufferFromAddress(address + 6L, headerSize);
        this.entriesUsed = Utils.readBytesAsUnsignedInt(header, 2);
        this.leftSiblingAddress = Utils.readBytesAsUnsignedLong(header, rootObject.getSuperblock().sizeOfOffsets);
        this.rightSiblingAddress = Utils.readBytesAsUnsignedLong(header, rootObject.getSuperblock().sizeOfOffsets);
        int keyBytes = (2 * this.entriesUsed + 1) * rootObject.getSuperblock().sizeOfLengths;
        int childPointerBytes = 2 * this.entriesUsed * rootObject.getSuperblock().sizeOfLengths;
        int keysAndPointersBytes = keyBytes + childPointerBytes;
        long keysAddress = address + 8L + 2L * (long)rootObject.getSuperblock().sizeOfOffsets;
        ByteBuffer keysAndPointersBuffer = rootObject.readBufferFromAddress(keysAddress, keysAndPointersBytes);
        this.childAddresses = new ArrayList<Long>(this.entriesUsed);
        for (int i = 0; i < this.entriesUsed; ++i) {
            keysAndPointersBuffer.position(keysAndPointersBuffer.position() + rootObject.getSuperblock().sizeOfLengths);
            this.childAddresses.add(Utils.readBytesAsUnsignedLong(keysAndPointersBuffer, rootObject.getSuperblock().sizeOfLengths));
        }
    }

    public H5BufferBuilder toBuffer() {
        H5BufferBuilder header = new H5BufferBuilder();
        this.toBuffer(header);
        return header;
    }

    public void toBuffer(H5BufferBuilder bb) {
        bb.writeBytes(BTREE_NODE_SIGNATURE);
        if (this.nodeType != 0) {
            throw new H5RuntimeException("B tree type is not group. Type is: " + this.nodeType);
        }
        bb.writeByte(this.nodeType);
        bb.writeByte(this.nodeLevel);
        bb.writeShort((short)this.entriesUsed);
        bb.writeLong(this.leftSiblingAddress);
        bb.writeLong(this.rightSiblingAddress);
        for (int i = 0; i < this.entriesUsed; ++i) {
            bb.writeBytes(new byte[this.rootObject.getSuperblock().sizeOfLengths]);
            bb.writeLong(this.childAddresses.get(i));
        }
    }

    public static ByteBuffer readHeaderAndValidateSignature(H5RootObject rootObject, long address) {
        ByteBuffer header = rootObject.readBufferFromAddress(address, 6);
        byte[] formatSignatureByte = new byte[4];
        header.get(formatSignatureByte, 0, formatSignatureByte.length);
        if (!Arrays.equals(BTREE_NODE_SIGNATURE, formatSignatureByte)) {
            throw new H5RuntimeException("B tree node signature not matched");
        }
        return header;
    }

    public List<Long> getChildAddresses() {
        return this.childAddresses;
    }
}

