/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers.CoordinatorController;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers.IController;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers.WorkerController;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.Request;

public class FederatedMonitoringServerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final Map<String, IController> _allControllers = new HashMap<String, IController>();
    private static final ThreadLocal<Request> _currentRequest = new ThreadLocal();

    public FederatedMonitoringServerHandler() {
        this._allControllers.put("/coordinators", new CoordinatorController());
        this._allControllers.put("/workers", new WorkerController());
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof LastHttpContent) {
            ByteBuf jsonBuf = ((LastHttpContent)msg).content();
            Request request = _currentRequest.get();
            request.setBody(jsonBuf.toString(CharsetUtil.UTF_8));
            _currentRequest.remove();
            FullHttpResponse response = this.processRequest(request);
            ctx.write((Object)response);
        } else if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            Request request = new Request();
            request.setContext(httpRequest);
            _currentRequest.set(request);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    private FullHttpResponse processRequest(Request request) {
        String method;
        IController controller = this.parseController(request.getContext().uri());
        switch (method = request.getContext().method().name()) {
            case "GET": {
                Long id = this.parseId(request.getContext().uri());
                if (id != null) {
                    return controller.get(request, id);
                }
                return controller.getAll(request);
            }
            case "PUT": {
                return controller.update(request, this.parseId(request.getContext().uri()));
            }
            case "POST": {
                return controller.create(request);
            }
            case "DELETE": {
                return controller.delete(request, this.parseId(request.getContext().uri()));
            }
        }
        throw new IllegalArgumentException("Method is not supported!");
    }

    private IController parseController(String currentPath) {
        Optional<String> controller = this._allControllers.keySet().stream().filter(currentPath::startsWith).findFirst();
        return controller.map(this._allControllers::get).orElseThrow(() -> new IllegalArgumentException("Such controller does not exist!"));
    }

    private Long parseId(String uri) {
        Pattern pattern = Pattern.compile("^[/][a-z]+[/]");
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find()) {
            return Long.valueOf(uri.substring(matcher.end()));
        }
        return null;
    }
}

