/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.HDFSTool;

public abstract class DataPartitioner {
    protected static final Log LOG = LogFactory.getLog((String)DataPartitioner.class.getName());
    protected static final double SPARSITY_CELL_THRESHOLD = 0.1;
    protected static final String NAME_SUFFIX = "_dp";
    protected ParForProgramBlock.PDataPartitionFormat _format = null;
    protected int _n = -1;
    protected boolean _allowBinarycell = true;

    protected DataPartitioner(ParForProgramBlock.PDataPartitionFormat dpf, int n) {
        this._format = dpf;
        this._n = n;
    }

    public MatrixObject createPartitionedMatrixObject(MatrixObject in, String fnameNew) {
        return this.createPartitionedMatrixObject(in, fnameNew, false);
    }

    public MatrixObject createPartitionedMatrixObject(MatrixObject in, String fnameNew, boolean force) {
        MatrixObject out = new MatrixObject(in.getValueType(), fnameNew);
        return this.createPartitionedMatrixObject(in, out, force);
    }

    public MatrixObject createPartitionedMatrixObject(MatrixObject in, MatrixObject out, boolean force) {
        if (this._format == ParForProgramBlock.PDataPartitionFormat.NONE) {
            return in;
        }
        MetaDataFormat meta = (MetaDataFormat)in.getMetaData();
        DataCharacteristics dc = meta.getDataCharacteristics();
        Types.FileFormat fmt = meta.getFileFormat();
        long rows = dc.getRows();
        long cols = dc.getCols();
        int blen = dc.getBlocksize();
        long nonZeros = dc.getNonZeros();
        if (!force) {
            if (rows < 2000L && cols < 2000L) {
                return in;
            }
            if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_WISE && cols < 2000L) {
                LOG.debug((Object)("Changing format from " + ParForProgramBlock.PDataPartitionFormat.ROW_WISE + " to " + ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE + "."));
                this._format = ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE;
            }
            if (this._format == ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE && rows < 2000L) {
                LOG.debug((Object)("Changing format from " + ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE + " to " + ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE + "."));
                this._format = ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE;
            }
        }
        String fnameNew = out.getFileName();
        try {
            HDFSTool.deleteFileIfExistOnHDFS(fnameNew);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        this.partitionMatrix(in, fnameNew, fmt, rows, cols, blen);
        out.setPartitioned(this._format, this._n);
        MatrixCharacteristics mcNew = new MatrixCharacteristics(rows, cols, blen);
        mcNew.setNonZeros(nonZeros);
        MetaDataFormat metaNew = new MetaDataFormat(mcNew, fmt);
        out.setMetaData(metaNew);
        return out;
    }

    public void disableBinaryCell() {
        this._allowBinarycell = false;
    }

    protected abstract void partitionMatrix(MatrixObject var1, String var2, Types.FileFormat var3, long var4, long var6, int var8);

    public static MatrixBlock createReuseMatrixBlock(ParForProgramBlock.PDataPartitionFormat dpf, int rows, int cols) {
        MatrixBlock tmp = null;
        switch (dpf) {
            case ROW_WISE: {
                tmp = new MatrixBlock(1, cols, true, (int)((double)cols * 0.1));
                break;
            }
            case COLUMN_WISE: {
                tmp = new MatrixBlock(rows, 1, false);
                break;
            }
        }
        return tmp;
    }
}

