/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.squareup.okhttp;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.Util;
import org.apache.hadoop.shaded.okio.ByteString;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Map<String, Set<ByteString>> hostnameToPins;

    private CertificatePinner(Builder builder) {
        this.hostnameToPins = Util.immutableMap(builder.hostnameToPins);
    }

    public void check(String hostname, List<Certificate> peerCertificates) throws SSLPeerUnverifiedException {
        Set<ByteString> pins = this.findMatchingPins(hostname);
        if (pins == null) {
            return;
        }
        int size = peerCertificates.size();
        for (int i = 0; i < size; ++i) {
            X509Certificate x509Certificate = (X509Certificate)peerCertificates.get(i);
            if (!pins.contains(CertificatePinner.sha1(x509Certificate))) continue;
            return;
        }
        StringBuilder message = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int size2 = peerCertificates.size();
        for (int i = 0; i < size2; ++i) {
            X509Certificate x509Certificate = (X509Certificate)peerCertificates.get(i);
            message.append("\n    ").append(CertificatePinner.pin(x509Certificate)).append(": ").append(x509Certificate.getSubjectDN().getName());
        }
        message.append("\n  Pinned certificates for ").append(hostname).append(":");
        for (ByteString pin : pins) {
            message.append("\n    sha1/").append(pin.base64());
        }
        throw new SSLPeerUnverifiedException(message.toString());
    }

    public void check(String hostname, Certificate ... peerCertificates) throws SSLPeerUnverifiedException {
        this.check(hostname, Arrays.asList(peerCertificates));
    }

    Set<ByteString> findMatchingPins(String hostname) {
        int indexOfLastDot;
        Set<ByteString> directPins = this.hostnameToPins.get(hostname);
        Set<ByteString> wildcardPins = null;
        int indexOfFirstDot = hostname.indexOf(46);
        if (indexOfFirstDot != (indexOfLastDot = hostname.lastIndexOf(46))) {
            wildcardPins = this.hostnameToPins.get("*." + hostname.substring(indexOfFirstDot + 1));
        }
        if (directPins == null && wildcardPins == null) {
            return null;
        }
        if (directPins != null && wildcardPins != null) {
            LinkedHashSet<ByteString> pins = new LinkedHashSet<ByteString>();
            pins.addAll(directPins);
            pins.addAll(wildcardPins);
            return pins;
        }
        if (directPins != null) {
            return directPins;
        }
        return wildcardPins;
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha1/" + CertificatePinner.sha1((X509Certificate)certificate).base64();
    }

    private static ByteString sha1(X509Certificate x509Certificate) {
        return Util.sha1(ByteString.of(x509Certificate.getPublicKey().getEncoded()));
    }

    public static final class Builder {
        private final Map<String, Set<ByteString>> hostnameToPins = new LinkedHashMap<String, Set<ByteString>>();

        public Builder add(String hostname, String ... pins) {
            if (hostname == null) {
                throw new IllegalArgumentException("hostname == null");
            }
            LinkedHashSet hostPins = new LinkedHashSet();
            Set previousPins = this.hostnameToPins.put(hostname, Collections.unmodifiableSet(hostPins));
            if (previousPins != null) {
                hostPins.addAll(previousPins);
            }
            for (String pin : pins) {
                if (!pin.startsWith("sha1/")) {
                    throw new IllegalArgumentException("pins must start with 'sha1/': " + pin);
                }
                ByteString decodedPin = ByteString.decodeBase64(pin.substring("sha1/".length()));
                if (decodedPin == null) {
                    throw new IllegalArgumentException("pins must be base64: " + pin);
                }
                hostPins.add(decodedPin);
            }
            return this;
        }

        public CertificatePinner build() {
            return new CertificatePinner(this);
        }
    }
}

