/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.hadoop.util.ReflectionUtils;

class Chain
extends org.apache.hadoop.mapreduce.lib.chain.Chain {
    private static final String MAPPER_BY_VALUE = "chain.mapper.byValue";
    private static final String REDUCER_BY_VALUE = "chain.reducer.byValue";
    private JobConf chainJobConf;
    private List<Mapper> mappers = new ArrayList<Mapper>();
    private Reducer reducer;
    private List<Serialization> mappersKeySerialization = new ArrayList<Serialization>();
    private List<Serialization> mappersValueSerialization = new ArrayList<Serialization>();
    private Serialization reducerKeySerialization;
    private Serialization reducerValueSerialization;
    private final ThreadLocal<DataOutputBuffer> threadLocalDataOutputBuffer = new ThreadLocal<DataOutputBuffer>(){

        @Override
        protected DataOutputBuffer initialValue() {
            return new DataOutputBuffer(1024);
        }
    };

    Chain(boolean isMap) {
        super(isMap);
    }

    public static <K1, V1, K2, V2> void addMapper(boolean isMap, JobConf jobConf, Class<? extends Mapper<K1, V1, K2, V2>> klass, Class<? extends K1> inputKeyClass, Class<? extends V1> inputValueClass, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass, boolean byValue, JobConf mapperConf) {
        String prefix = Chain.getPrefix(isMap);
        Chain.checkReducerAlreadySet(isMap, jobConf, prefix, true);
        int index = Chain.getIndex(jobConf, prefix);
        jobConf.setClass(prefix + ".mapper.class." + index, klass, Mapper.class);
        Chain.validateKeyValueTypes(isMap, jobConf, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, index, prefix);
        if (mapperConf == null) {
            mapperConf = new JobConf(true);
        }
        mapperConf.setBoolean(MAPPER_BY_VALUE, byValue);
        Chain.setMapperConf(isMap, jobConf, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, mapperConf, index, prefix);
    }

    public static <K1, V1, K2, V2> void setReducer(JobConf jobConf, Class<? extends Reducer<K1, V1, K2, V2>> klass, Class<? extends K1> inputKeyClass, Class<? extends V1> inputValueClass, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass, boolean byValue, JobConf reducerConf) {
        String prefix = Chain.getPrefix(false);
        Chain.checkReducerAlreadySet(false, jobConf, prefix, false);
        jobConf.setClass(prefix + ".reducer.class", klass, Reducer.class);
        if (reducerConf == null) {
            reducerConf = new JobConf(false);
        }
        reducerConf.setBoolean(REDUCER_BY_VALUE, byValue);
        Chain.setReducerConf(jobConf, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, reducerConf, prefix);
    }

    public void configure(JobConf jobConf) {
        String prefix = Chain.getPrefix(this.isMap);
        this.chainJobConf = jobConf;
        SerializationFactory serializationFactory = new SerializationFactory((Configuration)this.chainJobConf);
        int index = jobConf.getInt(prefix + ".size", 0);
        for (int i = 0; i < index; ++i) {
            Class klass = jobConf.getClass(prefix + ".mapper.class." + i, null, Mapper.class);
            JobConf mConf = new JobConf(Chain.getChainElementConf(jobConf, prefix + ".mapper.config." + i));
            Mapper mapper = (Mapper)ReflectionUtils.newInstance((Class)klass, (Configuration)mConf);
            this.mappers.add(mapper);
            if (mConf.getBoolean(MAPPER_BY_VALUE, true)) {
                this.mappersKeySerialization.add(serializationFactory.getSerialization(mConf.getClass("mapreduce.chain.mapper.output.key.class", null)));
                this.mappersValueSerialization.add(serializationFactory.getSerialization(mConf.getClass("mapreduce.chain.mapper.output.value.class", null)));
                continue;
            }
            this.mappersKeySerialization.add(null);
            this.mappersValueSerialization.add(null);
        }
        Class klass = jobConf.getClass(prefix + ".reducer.class", null, Reducer.class);
        if (klass != null) {
            JobConf rConf = new JobConf(Chain.getChainElementConf(jobConf, prefix + ".reducer.config"));
            this.reducer = (Reducer)ReflectionUtils.newInstance((Class)klass, (Configuration)rConf);
            if (rConf.getBoolean(REDUCER_BY_VALUE, true)) {
                this.reducerKeySerialization = serializationFactory.getSerialization(rConf.getClass("mapreduce.chain.reducer.output.key.class", null));
                this.reducerValueSerialization = serializationFactory.getSerialization(rConf.getClass("mapreduce.chain.reducer.output.value.class", null));
            } else {
                this.reducerKeySerialization = null;
                this.reducerValueSerialization = null;
            }
        }
    }

    protected JobConf getChainJobConf() {
        return this.chainJobConf;
    }

    public Mapper getFirstMap() {
        return this.mappers.size() > 0 ? this.mappers.get(0) : null;
    }

    public Reducer getReducer() {
        return this.reducer;
    }

    public OutputCollector getMapperCollector(int mapperIndex, OutputCollector output, Reporter reporter) {
        Serialization keySerialization = this.mappersKeySerialization.get(mapperIndex);
        Serialization valueSerialization = this.mappersValueSerialization.get(mapperIndex);
        return new ChainOutputCollector(mapperIndex, keySerialization, valueSerialization, output, reporter);
    }

    public OutputCollector getReducerCollector(OutputCollector output, Reporter reporter) {
        return new ChainOutputCollector(this.reducerKeySerialization, this.reducerValueSerialization, output, reporter);
    }

    public void close() throws IOException {
        for (Mapper map : this.mappers) {
            map.close();
        }
        if (this.reducer != null) {
            this.reducer.close();
        }
    }

    private class ChainOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private int nextMapperIndex;
        private Serialization<K> keySerialization;
        private Serialization<V> valueSerialization;
        private OutputCollector output;
        private Reporter reporter;

        public ChainOutputCollector(int index, Serialization<K> keySerialization, Serialization<V> valueSerialization, OutputCollector output, Reporter reporter) {
            this.nextMapperIndex = index + 1;
            this.keySerialization = keySerialization;
            this.valueSerialization = valueSerialization;
            this.output = output;
            this.reporter = reporter;
        }

        public ChainOutputCollector(Serialization<K> keySerialization, Serialization<V> valueSerialization, OutputCollector output, Reporter reporter) {
            this.nextMapperIndex = 0;
            this.keySerialization = keySerialization;
            this.valueSerialization = valueSerialization;
            this.output = output;
            this.reporter = reporter;
        }

        @Override
        public void collect(K key, V value) throws IOException {
            if (this.nextMapperIndex < Chain.this.mappers.size()) {
                if (this.keySerialization != null) {
                    key = this.makeCopyForPassByValue(this.keySerialization, key);
                    value = this.makeCopyForPassByValue(this.valueSerialization, value);
                }
                Serialization nextKeySerialization = (Serialization)Chain.this.mappersKeySerialization.get(this.nextMapperIndex);
                Serialization nextValueSerialization = (Serialization)Chain.this.mappersValueSerialization.get(this.nextMapperIndex);
                Mapper nextMapper = (Mapper)Chain.this.mappers.get(this.nextMapperIndex);
                nextMapper.map(key, value, new ChainOutputCollector<K, V>(this.nextMapperIndex, nextKeySerialization, nextValueSerialization, this.output, this.reporter), this.reporter);
            } else {
                this.output.collect(key, value);
            }
        }

        private <E> E makeCopyForPassByValue(Serialization<E> serialization, E obj) throws IOException {
            Serializer ser = serialization.getSerializer(GenericsUtil.getClass(obj));
            Deserializer deser = serialization.getDeserializer(GenericsUtil.getClass(obj));
            DataOutputBuffer dof = (DataOutputBuffer)Chain.this.threadLocalDataOutputBuffer.get();
            dof.reset();
            ser.open((OutputStream)dof);
            ser.serialize(obj);
            ser.close();
            obj = ReflectionUtils.newInstance((Class)GenericsUtil.getClass(obj), (Configuration)Chain.this.getChainJobConf());
            ByteArrayInputStream bais = new ByteArrayInputStream(dof.getData(), 0, dof.getLength());
            deser.open((InputStream)bais);
            deser.deserialize(obj);
            deser.close();
            return obj;
        }
    }
}

