/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.QueueACL;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobResourceUploader;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.base.Charsets;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class JobSubmitter {
    protected static final Logger LOG = LoggerFactory.getLogger(JobSubmitter.class);
    private static final String SHUFFLE_KEYGEN_ALGORITHM = "HmacSHA1";
    private static final int SHUFFLE_KEY_LENGTH = 64;
    private FileSystem jtFs;
    private ClientProtocol submitClient;
    private String submitHostName;
    private String submitHostAddress;

    JobSubmitter(FileSystem submitFs, ClientProtocol submitClient) throws IOException {
        this.submitClient = submitClient;
        this.jtFs = submitFs;
    }

    private void copyAndConfigureFiles(Job job, Path jobSubmitDir) throws IOException {
        Configuration conf = job.getConfiguration();
        boolean useWildcards = conf.getBoolean("mapreduce.client.libjars.wildcard", true);
        JobResourceUploader rUploader = new JobResourceUploader(this.jtFs, useWildcards);
        rUploader.uploadResources(job, jobSubmitDir);
        job.getWorkingDirectory();
    }

    JobStatus submitJobInternal(Job job, Cluster cluster) throws ClassNotFoundException, InterruptedException, IOException {
        this.checkSpecs(job);
        Configuration conf = job.getConfiguration();
        JobSubmitter.addMRFrameworkToDistributedCache(conf);
        Path jobStagingArea = JobSubmissionFiles.getStagingDir(cluster, conf);
        InetAddress ip = InetAddress.getLocalHost();
        if (ip != null) {
            this.submitHostAddress = ip.getHostAddress();
            this.submitHostName = ip.getHostName();
            conf.set("mapreduce.job.submithostname", this.submitHostName);
            conf.set("mapreduce.job.submithostaddress", this.submitHostAddress);
        }
        JobID jobId = this.submitClient.getNewJobID();
        job.setJobID(jobId);
        Path submitJobDir = new Path(jobStagingArea, jobId.toString());
        JobStatus status = null;
        try {
            ReservationId reservationId;
            conf.set("mapreduce.job.user.name", UserGroupInformation.getCurrentUser().getShortUserName());
            conf.set("hadoop.http.filter.initializers", "org.apache.hadoop.yarn.server.webproxy.amfilter.AmFilterInitializer");
            conf.set("mapreduce.job.dir", submitJobDir.toString());
            LOG.debug("Configuring job " + jobId + " with " + submitJobDir + " as the submit dir");
            TokenCache.obtainTokensForNamenodes(job.getCredentials(), new Path[]{submitJobDir}, conf);
            this.populateTokenCache(conf, job.getCredentials());
            if (TokenCache.getShuffleSecretKey(job.getCredentials()) == null) {
                KeyGenerator keyGen;
                try {
                    keyGen = KeyGenerator.getInstance(SHUFFLE_KEYGEN_ALGORITHM);
                    keyGen.init(64);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Error generating shuffle secret key", e);
                }
                SecretKey shuffleKey = keyGen.generateKey();
                TokenCache.setShuffleSecretKey(shuffleKey.getEncoded(), job.getCredentials());
            }
            if (CryptoUtils.isEncryptedSpillEnabled(conf)) {
                conf.setInt("mapreduce.am.max-attempts", 1);
                LOG.warn("Max job attempts set to 1 since encrypted intermediatedata spill is enabled");
            }
            this.copyAndConfigureFiles(job, submitJobDir);
            Path submitJobFile = JobSubmissionFiles.getJobConfPath(submitJobDir);
            LOG.debug("Creating splits at " + this.jtFs.makeQualified(submitJobDir));
            int maps = this.writeSplits(job, submitJobDir);
            conf.setInt("mapreduce.job.maps", maps);
            LOG.info("number of splits:" + maps);
            int maxMaps = conf.getInt("mapreduce.job.max.map", -1);
            if (maxMaps >= 0 && maxMaps < maps) {
                throw new IllegalArgumentException("The number of map tasks " + maps + " exceeded limit " + maxMaps);
            }
            String queue = conf.get("mapreduce.job.queuename", "default");
            AccessControlList acl = this.submitClient.getQueueAdmins(queue);
            conf.set(QueueManager.toFullPropertyName(queue, QueueACL.ADMINISTER_JOBS.getAclName()), acl.getAclString());
            TokenCache.cleanUpTokenReferral(conf);
            if (conf.getBoolean("mapreduce.job.token.tracking.ids.enabled", false)) {
                ArrayList<String> trackingIds = new ArrayList<String>();
                for (Token t : job.getCredentials().getAllTokens()) {
                    trackingIds.add(t.decodeIdentifier().getTrackingId());
                }
                conf.setStrings("mapreduce.job.token.tracking.ids", trackingIds.toArray(new String[trackingIds.size()]));
            }
            if ((reservationId = job.getReservationId()) != null) {
                conf.set("mapreduce.job.reservation.id", reservationId.toString());
            }
            this.writeConf(conf, submitJobFile);
            this.printTokens(jobId, job.getCredentials());
            status = this.submitClient.submitJob(jobId, submitJobDir.toString(), job.getCredentials());
            if (status != null) {
                JobStatus jobStatus = status;
                return jobStatus;
            }
            throw new IOException("Could not launch job");
        }
        finally {
            if (status == null) {
                LOG.info("Cleaning up the staging area " + submitJobDir);
                if (this.jtFs != null && submitJobDir != null) {
                    this.jtFs.delete(submitJobDir, true);
                }
            }
        }
    }

    private void checkSpecs(Job job) throws ClassNotFoundException, InterruptedException, IOException {
        JobConf jConf = (JobConf)job.getConfiguration();
        if (jConf.getNumReduceTasks() == 0 ? jConf.getUseNewMapper() : jConf.getUseNewReducer()) {
            OutputFormat output = (OutputFormat)ReflectionUtils.newInstance(job.getOutputFormatClass(), (Configuration)job.getConfiguration());
            output.checkOutputSpecs(job);
        } else {
            jConf.getOutputFormat().checkOutputSpecs(this.jtFs, jConf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConf(Configuration conf, Path jobFile) throws IOException {
        try (FSDataOutputStream out = FileSystem.create((FileSystem)this.jtFs, (Path)jobFile, (FsPermission)new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));){
            conf.writeXml((OutputStream)out);
        }
    }

    private void printTokens(JobID jobId, Credentials credentials) throws IOException {
        LOG.info("Submitting tokens for job: " + jobId);
        LOG.info("Executing with tokens: {}", (Object)credentials.getAllTokens());
    }

    private <T extends org.apache.hadoop.mapreduce.InputSplit> int writeNewSplits(JobContext job, Path jobSubmitDir) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = job.getConfiguration();
        InputFormat input = (InputFormat)ReflectionUtils.newInstance(job.getInputFormatClass(), (Configuration)conf);
        List<org.apache.hadoop.mapreduce.InputSplit> splits = input.getSplits(job);
        org.apache.hadoop.mapreduce.InputSplit[] array = splits.toArray(new org.apache.hadoop.mapreduce.InputSplit[splits.size()]);
        Arrays.sort(array, new SplitComparator());
        JobSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)conf, (FileSystem)jobSubmitDir.getFileSystem(conf), (org.apache.hadoop.mapreduce.InputSplit[])array);
        return array.length;
    }

    private int writeSplits(JobContext job, Path jobSubmitDir) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf jConf = (JobConf)job.getConfiguration();
        int maps = jConf.getUseNewMapper() ? this.writeNewSplits(job, jobSubmitDir) : this.writeOldSplits(jConf, jobSubmitDir);
        return maps;
    }

    private int writeOldSplits(JobConf job, Path jobSubmitDir) throws IOException {
        InputSplit[] splits = job.getInputFormat().getSplits(job, job.getNumMapTasks());
        Arrays.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                try {
                    long left = a.getLength();
                    long right = b.getLength();
                    if (left == right) {
                        return 0;
                    }
                    if (left < right) {
                        return 1;
                    }
                    return -1;
                }
                catch (IOException ie) {
                    throw new RuntimeException("Problem getting input split size", ie);
                }
            }
        });
        JobSplitWriter.createSplitFiles(jobSubmitDir, (Configuration)job, jobSubmitDir.getFileSystem((Configuration)job), splits);
        return splits.length;
    }

    private void readTokensFromFiles(Configuration conf, Credentials credentials) throws IOException {
        String tokensFileName;
        String binaryTokenFilename = conf.get("mapreduce.job.credentials.binary");
        if (binaryTokenFilename != null) {
            Credentials binary = Credentials.readTokenStorageFile((Path)FileSystem.getLocal((Configuration)conf).makeQualified(new Path(binaryTokenFilename)), (Configuration)conf);
            credentials.addAll(binary);
        }
        if ((tokensFileName = conf.get("mapreduce.job.credentials.json")) != null) {
            LOG.info("loading user's secret keys from " + tokensFileName);
            String localFileName = new Path(tokensFileName).toUri().getPath();
            try {
                Map nm = (Map)JsonSerialization.mapReader().readValue(new File(localFileName));
                for (Map.Entry ent : nm.entrySet()) {
                    credentials.addSecretKey(new Text((String)ent.getKey()), ((String)ent.getValue()).getBytes(Charsets.UTF_8));
                }
            }
            catch (JsonParseException | JsonMappingException e) {
                LOG.warn("couldn't parse Token Cache JSON file with user secret keys");
            }
        }
    }

    private void populateTokenCache(Configuration conf, Credentials credentials) throws IOException {
        this.readTokensFromFiles(conf, credentials);
        Object[] nameNodes = conf.getStrings("mapreduce.job.hdfs-servers");
        LOG.debug("adding the following namenodes' delegation tokens:" + Arrays.toString(nameNodes));
        if (nameNodes != null) {
            Path[] ps = new Path[nameNodes.length];
            for (int i = 0; i < nameNodes.length; ++i) {
                ps[i] = new Path((String)nameNodes[i]);
            }
            TokenCache.obtainTokensForNamenodes(credentials, ps, conf);
        }
    }

    private static void addMRFrameworkToDistributedCache(Configuration conf) throws IOException {
        String framework = conf.get("mapreduce.application.framework.path", "");
        if (!framework.isEmpty()) {
            URI uri;
            try {
                uri = new URI(framework);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to parse '" + framework + "' as a URI, check the setting for " + "mapreduce.application.framework.path", e);
            }
            String linkedName = uri.getFragment();
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            Path frameworkPath = fs.makeQualified(new Path(uri.getScheme(), uri.getAuthority(), uri.getPath()));
            FileContext fc = FileContext.getFileContext((URI)frameworkPath.toUri(), (Configuration)conf);
            frameworkPath = fc.resolvePath(frameworkPath);
            uri = frameworkPath.toUri();
            try {
                uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, linkedName);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            DistributedCache.addCacheArchive(uri, conf);
        }
    }

    private static class SplitComparator
    implements Comparator<org.apache.hadoop.mapreduce.InputSplit> {
        private SplitComparator() {
        }

        @Override
        public int compare(org.apache.hadoop.mapreduce.InputSplit o1, org.apache.hadoop.mapreduce.InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
        }
    }
}

