/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesResponse;
import org.apache.hadoop.yarn.api.records.NodeAttributeInfo;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeAttributeInfoPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetClusterNodeAttributesResponsePBImpl
extends GetClusterNodeAttributesResponse {
    private YarnServiceProtos.GetClusterNodeAttributesResponseProto proto = YarnServiceProtos.GetClusterNodeAttributesResponseProto.getDefaultInstance();
    private YarnServiceProtos.GetClusterNodeAttributesResponseProto.Builder builder = null;
    private Set<NodeAttributeInfo> clusterNodeAttributes;
    private boolean viaProto = false;

    public GetClusterNodeAttributesResponsePBImpl() {
        this.builder = YarnServiceProtos.GetClusterNodeAttributesResponseProto.newBuilder();
    }

    public GetClusterNodeAttributesResponsePBImpl(YarnServiceProtos.GetClusterNodeAttributesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServiceProtos.GetClusterNodeAttributesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.clusterNodeAttributes != null) {
            this.addNodeAttributesToProto();
        }
    }

    private void addNodeAttributesToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeAttributes();
        if (this.clusterNodeAttributes == null || this.clusterNodeAttributes.isEmpty()) {
            return;
        }
        this.builder.addAllNodeAttributes((Iterable)this.clusterNodeAttributes.stream().map(s -> this.convertToProtoFormat((NodeAttributeInfo)s)).collect(Collectors.toSet()));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((GetClusterNodeAttributesResponsePBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetClusterNodeAttributesResponseProto.newBuilder((YarnServiceProtos.GetClusterNodeAttributesResponseProto)this.proto);
        }
        this.viaProto = false;
    }

    public synchronized void setNodeAttributes(Set<NodeAttributeInfo> attributes) {
        this.maybeInitBuilder();
        this.clusterNodeAttributes = new HashSet<NodeAttributeInfo>();
        if (attributes == null) {
            this.builder.clearNodeAttributes();
            return;
        }
        this.clusterNodeAttributes.addAll(attributes);
    }

    public synchronized Set<NodeAttributeInfo> getNodeAttributes() {
        if (this.clusterNodeAttributes != null) {
            return this.clusterNodeAttributes;
        }
        this.initLocalNodeAttributes();
        return this.clusterNodeAttributes;
    }

    private void initLocalNodeAttributes() {
        YarnServiceProtos.GetClusterNodeAttributesResponseProto p = this.viaProto ? this.proto : this.builder;
        List attributesProtoList = p.getNodeAttributesList();
        this.clusterNodeAttributes = new HashSet<NodeAttributeInfo>();
        this.clusterNodeAttributes.addAll(attributesProtoList.stream().map(attr -> this.convertFromProtoFormat((YarnProtos.NodeAttributeInfoProto)attr)).collect(Collectors.toSet()));
    }

    private YarnProtos.NodeAttributeInfoProto convertToProtoFormat(NodeAttributeInfo attributeInfo) {
        return ((NodeAttributeInfoPBImpl)attributeInfo).getProto();
    }

    private NodeAttributeInfo convertFromProtoFormat(YarnProtos.NodeAttributeInfoProto nodeAttributeInfoProto) {
        return new NodeAttributeInfoPBImpl(nodeAttributeInfoProto);
    }

    public String toString() {
        return this.getProto().toString();
    }
}

