/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ResourceAllocationRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceAllocationRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ReservationAllocationStatePBImpl
extends ReservationAllocationState {
    private YarnProtos.ReservationAllocationStateProto proto = YarnProtos.ReservationAllocationStateProto.getDefaultInstance();
    private YarnProtos.ReservationAllocationStateProto.Builder builder = null;
    private boolean viaProto = false;
    private List<ResourceAllocationRequest> resourceAllocations = null;
    private ReservationId reservationId = null;
    private ReservationDefinition reservationDefinition = null;

    public ReservationAllocationStatePBImpl() {
        this.builder = YarnProtos.ReservationAllocationStateProto.newBuilder();
    }

    public ReservationAllocationStatePBImpl(YarnProtos.ReservationAllocationStateProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ReservationAllocationStateProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ReservationAllocationStateProto.newBuilder((YarnProtos.ReservationAllocationStateProto)this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.resourceAllocations != null) {
            int size = this.resourceAllocations.size();
            this.builder.clearAllocationRequests();
            for (int i = 0; i < size; ++i) {
                this.builder.addAllocationRequests(i, this.convertToProtoFormat(this.resourceAllocations.get(i)));
            }
        }
        if (this.reservationId != null) {
            this.builder.setReservationId(this.convertToProtoFormat(this.reservationId));
        }
        if (this.reservationDefinition != null) {
            this.builder.setReservationDefinition(this.convertToProtoFormat(this.reservationDefinition));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public long getAcceptanceTime() {
        YarnProtos.ReservationAllocationStateProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAcceptanceTime()) {
            return 0L;
        }
        return p.getAcceptanceTime();
    }

    public void setAcceptanceTime(long acceptanceTime) {
        this.maybeInitBuilder();
        if (acceptanceTime <= 0L) {
            this.builder.clearAcceptanceTime();
            return;
        }
        this.builder.setAcceptanceTime(acceptanceTime);
    }

    public String getUser() {
        YarnProtos.ReservationAllocationStateProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasUser()) {
            return null;
        }
        return p.getUser();
    }

    public void setUser(String user) {
        this.maybeInitBuilder();
        if (user == null) {
            this.builder.clearUser();
            return;
        }
        this.builder.setUser(user);
    }

    public List<ResourceAllocationRequest> getResourceAllocationRequests() {
        this.initResourceAllocations();
        return this.resourceAllocations;
    }

    public void setResourceAllocationRequests(List<ResourceAllocationRequest> newResourceAllocations) {
        this.maybeInitBuilder();
        if (newResourceAllocations == null) {
            this.builder.clearAllocationRequests();
        }
        this.resourceAllocations = newResourceAllocations;
    }

    public ReservationId getReservationId() {
        YarnProtos.ReservationAllocationStateProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.reservationId != null) {
            return this.reservationId;
        }
        this.reservationId = this.convertFromProtoFormat(p.getReservationId());
        return this.reservationId;
    }

    public void setReservationId(ReservationId newReservationId) {
        this.maybeInitBuilder();
        if (newReservationId == null) {
            this.builder.clearReservationId();
        }
        this.reservationId = newReservationId;
    }

    public ReservationDefinition getReservationDefinition() {
        YarnProtos.ReservationAllocationStateProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.reservationDefinition != null) {
            return this.reservationDefinition;
        }
        this.reservationDefinition = this.convertFromProtoFormat(p.getReservationDefinition());
        return this.reservationDefinition;
    }

    public void setReservationDefinition(ReservationDefinition newReservationDefinition) {
        this.maybeInitBuilder();
        if (newReservationDefinition == null) {
            this.builder.clearReservationDefinition();
        }
        this.reservationDefinition = newReservationDefinition;
    }

    private ResourceAllocationRequestPBImpl convertFromProtoFormat(YarnProtos.ResourceAllocationRequestProto p) {
        return new ResourceAllocationRequestPBImpl(p);
    }

    private ReservationIdPBImpl convertFromProtoFormat(YarnProtos.ReservationIdProto p) {
        return new ReservationIdPBImpl(p);
    }

    private ReservationDefinitionPBImpl convertFromProtoFormat(YarnProtos.ReservationDefinitionProto p) {
        return new ReservationDefinitionPBImpl(p);
    }

    private YarnProtos.ResourceAllocationRequestProto convertToProtoFormat(ResourceAllocationRequest p) {
        return ((ResourceAllocationRequestPBImpl)p).getProto();
    }

    private YarnProtos.ReservationIdProto convertToProtoFormat(ReservationId p) {
        return ((ReservationIdPBImpl)p).getProto();
    }

    private YarnProtos.ReservationDefinitionProto convertToProtoFormat(ReservationDefinition p) {
        return ((ReservationDefinitionPBImpl)p).getProto();
    }

    private void initResourceAllocations() {
        if (this.resourceAllocations != null) {
            return;
        }
        YarnProtos.ReservationAllocationStateProto p = this.viaProto ? this.proto : this.builder;
        List resourceAllocationProtos = p.getAllocationRequestsList();
        this.resourceAllocations = new ArrayList<ResourceAllocationRequest>();
        for (YarnProtos.ResourceAllocationRequestProto r : resourceAllocationProtos) {
            this.resourceAllocations.add(this.convertFromProtoFormat(r));
        }
    }

    public String toString() {
        return "{Acceptance Time: " + this.getAcceptanceTime() + ", User: " + this.getUser() + ", Resource Allocations: " + this.getResourceAllocationRequests() + ", Reservation Id: " + this.getReservationId() + ", Reservation Definition: " + this.getReservationDefinition() + "}";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ReservationAllocationStatePBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }
}

