/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.AttributeMappingOperationType;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeToAttributes;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodesToAttributesMappingRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NodeToAttributesPBImpl;

public class NodesToAttributesMappingRequestPBImpl
extends NodesToAttributesMappingRequest {
    private YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto proto = YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto.getDefaultInstance();
    private YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto.Builder builder = null;
    private boolean viaProto = false;
    private List<NodeToAttributes> nodeAttributesMapping = null;

    public NodesToAttributesMappingRequestPBImpl() {
        this.builder = YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto.newBuilder();
    }

    public NodesToAttributesMappingRequestPBImpl(YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        if (this.nodeAttributesMapping != null) {
            for (NodeToAttributes nodeAttributes : this.nodeAttributesMapping) {
                this.builder.addNodeToAttributes(((NodeToAttributesPBImpl)nodeAttributes).getProto());
            }
        }
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto.newBuilder((YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    public void setNodesToAttributes(List<NodeToAttributes> nodesToAttributes) {
        if (this.nodeAttributesMapping == null) {
            this.nodeAttributesMapping = new ArrayList<NodeToAttributes>();
        }
        if (nodesToAttributes == null) {
            throw new IllegalArgumentException("nodesToAttributes cannot be null");
        }
        this.nodeAttributesMapping.clear();
        this.nodeAttributesMapping.addAll(nodesToAttributes);
    }

    private void initNodeAttributesMapping() {
        if (this.nodeAttributesMapping != null) {
            return;
        }
        YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto p = this.viaProto ? this.proto : this.builder;
        List nodeAttributesProtoList = p.getNodeToAttributesList();
        ArrayList<NodeToAttributes> attributes = new ArrayList<NodeToAttributes>();
        if (nodeAttributesProtoList == null || nodeAttributesProtoList.size() == 0) {
            this.nodeAttributesMapping = attributes;
            return;
        }
        for (YarnProtos.NodeToAttributesProto nodeAttributeProto : nodeAttributesProtoList) {
            attributes.add(new NodeToAttributesPBImpl(nodeAttributeProto));
        }
        this.nodeAttributesMapping = attributes;
    }

    public List<NodeToAttributes> getNodesToAttributes() {
        this.initNodeAttributesMapping();
        return this.nodeAttributesMapping;
    }

    public void setFailOnUnknownNodes(boolean failOnUnknownNodes) {
        this.maybeInitBuilder();
        this.builder.setFailOnUnknownNodes(failOnUnknownNodes);
    }

    public boolean getFailOnUnknownNodes() {
        YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto p = this.viaProto ? this.proto : this.builder;
        return p.getFailOnUnknownNodes();
    }

    public void setOperation(AttributeMappingOperationType operation) {
        this.maybeInitBuilder();
        this.builder.setOperation(this.convertToProtoFormat(operation));
    }

    private YarnServerResourceManagerServiceProtos.AttributeMappingOperationTypeProto convertToProtoFormat(AttributeMappingOperationType operation) {
        return YarnServerResourceManagerServiceProtos.AttributeMappingOperationTypeProto.valueOf((String)operation.name());
    }

    private AttributeMappingOperationType convertFromProtoFormat(YarnServerResourceManagerServiceProtos.AttributeMappingOperationTypeProto operationTypeProto) {
        return AttributeMappingOperationType.valueOf((String)operationTypeProto.name());
    }

    public AttributeMappingOperationType getOperation() {
        YarnServerResourceManagerServiceProtos.NodesToAttributesMappingRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasOperation()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getOperation());
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NodesToAttributesMappingRequest) {
            NodesToAttributesMappingRequest other = (NodesToAttributesMappingRequest)obj;
            if (this.getNodesToAttributes() == null ? other.getNodesToAttributes() != null : !this.getNodesToAttributes().containsAll(other.getNodesToAttributes())) {
                return false;
            }
            if (this.getOperation() == null ? other.getOperation() != null : !this.getOperation().equals((Object)other.getOperation())) {
                return false;
            }
            return this.getFailOnUnknownNodes() == other.getFailOnUnknownNodes();
        }
        return false;
    }
}

