/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.util.AbstractTraverser;
import org.codehaus.janino.util.Objects;

public class ScriptEvaluator
extends ClassBodyEvaluator
implements IScriptEvaluator {
    public static final String DEFAULT_METHOD_NAME = "eval*";
    @Nullable
    private Script[] scripts;

    public void setScriptCount(int count) {
        Script[] ss = this.scripts;
        if (ss == null) {
            this.scripts = ss = new Script[count];
            for (int i = 0; i < count; ++i) {
                ss[i] = new Script(DEFAULT_METHOD_NAME.replace("*", Integer.toString(i)));
            }
        } else if (count != ss.length) {
            throw new IllegalArgumentException("Inconsistent script count; previously " + ss.length + ", now " + count);
        }
    }

    private Script getScript(int index) {
        if (this.scripts != null) {
            return this.scripts[index];
        }
        throw new IllegalStateException("\"getScript()\" invoked befor \"setScriptCount()\"");
    }

    public ScriptEvaluator(String script) throws CompileException {
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType) throws CompileException {
        this.setReturnType(returnType);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.cook(script);
    }

    public ScriptEvaluator(@Nullable String optionalFileName, InputStream is, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, is);
    }

    public ScriptEvaluator(@Nullable String optionalFileName, Reader reader, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, reader);
    }

    public ScriptEvaluator(Scanner scanner, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, @Nullable Class<?> optionalExtendedType, Class<?>[] implementedTypes, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, String className, @Nullable Class<?> optionalExtendedType, Class<?>[] implementedTypes, boolean staticMethod, Class<?> returnType, String methodName, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setClassName(className);
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setStaticMethod(staticMethod);
        this.setReturnType(returnType);
        this.setMethodName(methodName);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator() {
    }

    public ScriptEvaluator(int count) {
        this.setScriptCount(count);
    }

    public void setOverrideMethod(boolean overrideMethod) {
        this.setOverrideMethod(new boolean[]{overrideMethod});
    }

    public void setStaticMethod(boolean staticMethod) {
        this.setStaticMethod(new boolean[]{staticMethod});
    }

    public void setReturnType(Class<?> returnType) {
        this.setReturnTypes(new Class[]{returnType});
    }

    public void setMethodName(String methodName) {
        this.setMethodNames(new String[]{methodName});
    }

    public void setParameters(String[] parameterNames, Class<?>[] parameterTypes) {
        this.setParameters(new String[][]{parameterNames}, new Class[][]{parameterTypes});
    }

    public void setThrownExceptions(Class<?>[] thrownExceptions) {
        this.setThrownExceptions(new Class[][]{thrownExceptions});
    }

    public void setOverrideMethod(boolean[] overrideMethod) {
        this.setScriptCount(overrideMethod.length);
        for (int i = 0; i < overrideMethod.length; ++i) {
            this.getScript((int)i).overrideMethod = overrideMethod[i];
        }
    }

    public void setStaticMethod(boolean[] staticMethod) {
        this.setScriptCount(staticMethod.length);
        for (int i = 0; i < staticMethod.length; ++i) {
            this.getScript((int)i).staticMethod = staticMethod[i];
        }
    }

    public void setReturnTypes(Class<?>[] returnTypes) {
        this.setScriptCount(returnTypes.length);
        for (int i = 0; i < returnTypes.length; ++i) {
            this.getScript((int)i).returnType = Objects.or(returnTypes[i], this.getDefaultReturnType());
        }
    }

    public void setMethodNames(String[] methodNames) {
        this.setScriptCount(methodNames.length);
        for (int i = 0; i < methodNames.length; ++i) {
            this.getScript(i).methodName = methodNames[i];
        }
    }

    public void setParameters(String[][] parameterNames, Class<?>[][] parameterTypes) {
        int i;
        this.setScriptCount(parameterNames.length);
        for (i = 0; i < parameterNames.length; ++i) {
            Script.access$102(this.getScript(i), (String[])parameterNames[i].clone());
        }
        this.setScriptCount(parameterTypes.length);
        for (i = 0; i < parameterTypes.length; ++i) {
            Script.access$202(this.getScript(i), (Class[])parameterTypes[i].clone());
        }
    }

    public void setThrownExceptions(Class<?>[][] thrownExceptions) {
        this.setScriptCount(thrownExceptions.length);
        for (int i = 0; i < thrownExceptions.length; ++i) {
            Script.access$302(this.getScript(i), thrownExceptions[i]);
        }
    }

    public final void cook(String[] strings) throws CompileException {
        this.cook(null, strings);
    }

    public final void cook(@Nullable String[] optionalFileNames, String[] strings) throws CompileException {
        Reader[] readers = new Reader[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            readers[i] = new StringReader(strings[i]);
        }
        try {
            this.cook(optionalFileNames, readers);
        }
        catch (IOException ex) {
            throw new InternalCompilerException("SNO: IOException despite StringReader", ex);
        }
    }

    public final void cook(Reader[] readers) throws CompileException, IOException {
        this.cook(null, readers);
    }

    public final void cook(@Nullable String[] optionalFileNames, Reader[] readers) throws CompileException, IOException {
        if (optionalFileNames != null) {
            this.setScriptCount(optionalFileNames.length);
        }
        this.setScriptCount(readers.length);
        Scanner[] scanners = new Scanner[readers.length];
        for (int i = 0; i < readers.length; ++i) {
            scanners[i] = new Scanner(optionalFileNames == null ? null : optionalFileNames[i], readers[i]);
        }
        this.cook(scanners);
    }

    @Override
    public final void cook(Scanner scanner) throws CompileException, IOException {
        this.cook(new Scanner[]{scanner});
    }

    public final void cook(Scanner[] scanners) throws CompileException, IOException {
        this.setScriptCount(scanners.length);
        Parser[] parsers = new Parser[scanners.length];
        for (int i = 0; i < scanners.length; ++i) {
            parsers[i] = new Parser(scanners[i]);
        }
        this.cook(parsers);
    }

    public final void cook(Parser[] parsers) throws CompileException, IOException {
        this.setScriptCount(parsers.length);
        Java.CompilationUnit compilationUnit = this.makeCompilationUnit(parsers.length == 1 ? parsers[0] : null);
        Java.PackageMemberClassDeclaration cd = this.addPackageMemberClassDeclaration(parsers[0].location(), compilationUnit);
        for (int i = 0; i < parsers.length; ++i) {
            Java.Annotation[] annotationArray;
            Script es = this.getScript(i);
            Parser parser = parsers[i];
            ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
            ArrayList<Java.MethodDeclarator> localMethods = new ArrayList<Java.MethodDeclarator>();
            this.makeStatements(i, parser, statements, localMethods);
            Location loc = parser.location();
            if (es.overrideMethod) {
                Java.Annotation[] annotationArray2 = new Java.Annotation[1];
                annotationArray = annotationArray2;
                annotationArray2[0] = new Java.MarkerAnnotation(this.classToType(loc, Override.class));
            } else {
                annotationArray = new Java.Annotation[]{};
            }
            cd.addDeclaredMethod(this.makeMethodDeclaration(loc, annotationArray, es.staticMethod, es.returnType, es.methodName, es.parameterTypes, es.parameterNames, es.thrownExceptions, statements));
            for (Java.MethodDeclarator method : localMethods) {
                cd.addDeclaredMethod(method);
            }
        }
        this.cook2(compilationUnit);
    }

    protected void cook2(Java.CompilationUnit compilationUnit) throws CompileException {
        Class<?> c = this.compileToClass(compilationUnit);
        assert (this.scripts != null);
        int count = this.scripts.length;
        for (int i = 0; i < count; ++i) {
            this.getScript(i).result = null;
        }
        HashMap<Object, Integer> dms = new HashMap<Object, Integer>(2 * count);
        for (int i = 0; i < count; ++i) {
            Script es = this.getScript(i);
            Integer prev = dms.put(ScriptEvaluator.methodKey(es.methodName, es.parameterTypes), i);
            assert (prev == null);
        }
        for (Method m : c.getDeclaredMethods()) {
            Integer idx = (Integer)dms.get(ScriptEvaluator.methodKey(m.getName(), m.getParameterTypes()));
            if (idx == null) continue;
            Script es = this.getScript(idx);
            assert (es.result == null);
            es.result = m;
        }
        for (int i = 0; i < count; ++i) {
            Script es = this.getScript(i);
            if (es.result != null) continue;
            throw new InternalCompilerException("SNO: Generated class does not declare method \"" + es.methodName + "\" (index " + i + ")");
        }
    }

    private static Object methodKey(String methodName, Class<?>[] parameterTypes) {
        return Arrays.asList(ScriptEvaluator.cat(methodName, parameterTypes, Object.class));
    }

    private static <T> T[] cat(T firstElement, T[] followingElements, Class<T> componentType) {
        Object[] result = (Object[])Array.newInstance(componentType, 1 + followingElements.length);
        result[0] = firstElement;
        System.arraycopy(followingElements, 0, result, 1, followingElements.length);
        return result;
    }

    @Nullable
    public Object evaluate(@Nullable Object[] arguments) throws InvocationTargetException {
        return this.evaluate(0, arguments);
    }

    @Nullable
    public Object evaluate(int idx, @Nullable Object[] arguments) throws InvocationTargetException {
        Method method = this.getMethod(idx);
        try {
            return method.invoke(null, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new InternalCompilerException(ex.toString(), ex);
        }
    }

    public Method getMethod() {
        return this.getMethod(0);
    }

    public Method getMethod(int idx) {
        return this.getScript(idx).getResult();
    }

    protected Class<?> getDefaultReturnType() {
        return Void.TYPE;
    }

    protected final Class<?> getReturnType(int index) {
        return this.getScript((int)index).returnType;
    }

    protected void makeStatements(int idx, Parser parser, List<Java.BlockStatement> resultStatements, List<Java.MethodDeclarator> resultMethods) throws CompileException, IOException {
        while (!parser.peek(TokenType.END_OF_INPUT)) {
            ScriptEvaluator.parseScriptStatement(parser, resultStatements, resultMethods);
        }
    }

    private static void parseScriptStatement(Parser parser, List<Java.BlockStatement> mainStatements, List<Java.MethodDeclarator> localMethods) throws CompileException, IOException {
        if (parser.peek(TokenType.IDENTIFIER) && parser.peekNextButOne(":") || parser.peek("if", "for", "while", "do", "try", "switch", "synchronized", "return", "throw", "break", "continue", "assert", "{", ";") != -1) {
            mainStatements.add(parser.parseStatement());
            return;
        }
        if (parser.peekRead("class")) {
            Java.LocalClassDeclaration lcd = (Java.LocalClassDeclaration)parser.parseClassDeclarationRest(null, new Java.Modifier[0], Parser.ClassDeclarationContext.BLOCK);
            mainStatements.add(new Java.LocalClassDeclarationStatement(lcd));
            return;
        }
        Java.Modifier[] modifiers = parser.parseModifiers();
        if (parser.peekRead("void")) {
            String name = parser.read(TokenType.IDENTIFIER);
            localMethods.add(parser.parseMethodDeclarationRest(null, modifiers, null, new Java.PrimitiveType(parser.location(), Java.Primitive.VOID), name, false, Parser.MethodDeclarationContext.CLASS_DECLARATION));
            return;
        }
        if (modifiers.length > 0) {
            Java.Type methodOrVariableType = parser.parseType();
            if (parser.peek(TokenType.IDENTIFIER) && parser.peekNextButOne("(")) {
                localMethods.add(parser.parseMethodDeclarationRest(null, modifiers, null, methodOrVariableType, parser.read(TokenType.IDENTIFIER), false, Parser.MethodDeclarationContext.CLASS_DECLARATION));
                return;
            }
            mainStatements.add(new Java.LocalVariableDeclarationStatement(parser.location(), modifiers, methodOrVariableType, parser.parseVariableDeclarators()));
            parser.read(";");
            return;
        }
        Java.Atom a = parser.parseExpression();
        if (parser.peekRead(";")) {
            mainStatements.add(new Java.ExpressionStatement(a.toRvalueOrCompileException()));
            return;
        }
        Java.Type methodOrVariableType = a.toTypeOrCompileException();
        if (parser.peek(TokenType.IDENTIFIER) && parser.peekNextButOne("(")) {
            localMethods.add(parser.parseMethodDeclarationRest(null, modifiers, null, methodOrVariableType, parser.read(TokenType.IDENTIFIER), false, Parser.MethodDeclarationContext.CLASS_DECLARATION));
            return;
        }
        mainStatements.add(new Java.LocalVariableDeclarationStatement(a.getLocation(), modifiers, methodOrVariableType, parser.parseVariableDeclarators()));
        parser.read(";");
    }

    private Java.MethodDeclarator makeMethodDeclaration(Location location, Java.Annotation[] annotations, boolean staticMethod, Class<?> returnType, String methodName, Class<?>[] parameterTypes, String[] parameterNames, Class<?>[] thrownExceptions, List<Java.BlockStatement> statements) {
        if (parameterNames.length != parameterTypes.length) {
            throw new InternalCompilerException("Lengths of \"parameterNames\" (" + parameterNames.length + ") and \"parameterTypes\" (" + parameterTypes.length + ") do not match");
        }
        Java.FunctionDeclarator.FormalParameters fps = new Java.FunctionDeclarator.FormalParameters(location, new Java.FunctionDeclarator.FormalParameter[parameterNames.length], false);
        for (int i = 0; i < fps.parameters.length; ++i) {
            fps.parameters[i] = new Java.FunctionDeclarator.FormalParameter(location, Java.accessModifiers(location, "final"), this.classToType(location, parameterTypes[i]), parameterNames[i]);
        }
        ArrayList<Java.Modifier> l = new ArrayList<Java.Modifier>();
        l.addAll(Arrays.asList(annotations));
        l.add(new Java.AccessModifier("public", location));
        if (staticMethod) {
            l.add(new Java.AccessModifier("static", location));
        }
        Java.Modifier[] modifiers = l.toArray(new Java.Modifier[l.size()]);
        return new Java.MethodDeclarator(location, null, modifiers, null, this.classToType(location, returnType), methodName, fps, this.classesToTypes(location, thrownExceptions), null, statements);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(String script, Class<?> interfaceToImplement, String[] parameterNames) throws CompileException {
        ScriptEvaluator se = new ScriptEvaluator();
        return se.createFastEvaluator(script, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, Class<?> interfaceToImplement, String[] parameterNames, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, String className, @Nullable Class<?> optionalExtendedType, Class<?> interfaceToImplement, String[] parameterNames, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setClassName(className);
        se.setExtendedClass(optionalExtendedType);
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, @Nullable String[] optionalDefaultImports, String className, @Nullable Class<?> optionalExtendedClass, Class<?> interfaceToImplement, String[] parameterNames, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setDefaultImports(optionalDefaultImports);
        se.setClassName(className);
        se.setExtendedClass(optionalExtendedClass);
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Override
    public final Object createInstance(Reader reader) {
        throw new UnsupportedOperationException("createInstance");
    }

    public <T> Object createFastEvaluator(Reader reader, Class<T> interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        return this.createFastEvaluator(new Scanner(null, reader), interfaceToImplement, parameterNames);
    }

    public <T> Object createFastEvaluator(String script, Class<T> interfaceToImplement, String[] parameterNames) throws CompileException {
        try {
            return this.createFastEvaluator(new StringReader(script), interfaceToImplement, parameterNames);
        }
        catch (IOException ex) {
            throw new InternalCompilerException("IOException despite StringReader", ex);
        }
    }

    public Object createFastEvaluator(Scanner scanner, Class<?> interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        if (!interfaceToImplement.isInterface()) {
            throw new InternalCompilerException("\"" + interfaceToImplement + "\" is not an interface");
        }
        Method[] methods = interfaceToImplement.getDeclaredMethods();
        if (methods.length != 1) {
            throw new InternalCompilerException("Interface \"" + interfaceToImplement + "\" must declare exactly one method");
        }
        Method methodToImplement = methods[0];
        this.setImplementedInterfaces(new Class[]{interfaceToImplement});
        this.setOverrideMethod(true);
        this.setStaticMethod(false);
        if (this instanceof IExpressionEvaluator) {
            ((IExpressionEvaluator)this).setExpressionType(methodToImplement.getReturnType());
        } else {
            this.setReturnType(methodToImplement.getReturnType());
        }
        this.setMethodName(methodToImplement.getName());
        this.setParameters(parameterNames, methodToImplement.getParameterTypes());
        this.setThrownExceptions(methodToImplement.getExceptionTypes());
        this.cook(scanner);
        Class<?> c = this.getMethod().getDeclaringClass();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new InternalCompilerException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerException(e.toString(), e);
        }
    }

    public static String[] guessParameterNames(Scanner scanner) throws CompileException, IOException {
        Parser parser = new Parser(scanner);
        while (parser.peek("import")) {
            parser.parseImportDeclaration();
        }
        Java.Block block = new Java.Block(scanner.location());
        while (!parser.peek(TokenType.END_OF_INPUT)) {
            block.addStatement(parser.parseBlockStatement());
        }
        final HashSet localVariableNames = new HashSet();
        final HashSet parameterNames = new HashSet();
        new AbstractTraverser<RuntimeException>(){

            @Override
            public void traverseLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
                    localVariableNames.add(vd.name);
                }
                super.traverseLocalVariableDeclarationStatement(lvds);
            }

            @Override
            public void traverseAmbiguousName(Java.AmbiguousName an) {
                for (int i = 0; i < an.identifiers.length; ++i) {
                    if (!Character.isUpperCase(an.identifiers[i].charAt(0))) continue;
                    return;
                }
                if (localVariableNames.contains(an.identifiers[0])) {
                    return;
                }
                parameterNames.add(an.identifiers[0]);
            }
        }.visitBlockStatement(block);
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    class Script {
        protected boolean overrideMethod;
        protected boolean staticMethod = true;
        protected Class<?> returnType = ScriptEvaluator.this.getDefaultReturnType();
        private String methodName;
        private String[] parameterNames = new String[0];
        private Class<?>[] parameterTypes = new Class[0];
        private Class<?>[] thrownExceptions = new Class[0];
        @Nullable
        private Method result;

        Script(String methodName) {
            this.methodName = methodName;
        }

        public Method getResult() {
            if (this.result != null) {
                return this.result;
            }
            throw new IllegalStateException("Script is not yet cooked");
        }

        static /* synthetic */ String[] access$102(Script x0, String[] x1) {
            x0.parameterNames = x1;
            return x1;
        }

        static /* synthetic */ Class[] access$202(Script x0, Class[] x1) {
            x0.parameterTypes = x1;
            return x1;
        }

        static /* synthetic */ Class[] access$302(Script x0, Class[] x1) {
            x0.thrownExceptions = x1;
            return x1;
        }
    }
}

