/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.util;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class LocalResourceBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(LocalResourceBuilder.class);
    private Configuration conf;
    private LocalResourceType type;
    private URI[] uris;
    private long[] timestamps;
    private long[] sizes;
    private boolean[] visibilities;
    private Map<String, Boolean> sharedCacheUploadPolicies;

    LocalResourceBuilder() {
    }

    void setConf(Configuration c) {
        this.conf = c;
    }

    void setType(LocalResourceType t) {
        this.type = t;
    }

    void setUris(URI[] u) {
        this.uris = u;
    }

    void setTimestamps(long[] t) {
        this.timestamps = t;
    }

    void setSizes(long[] s) {
        this.sizes = s;
    }

    void setVisibilities(boolean[] v) {
        this.visibilities = v;
    }

    void setSharedCacheUploadPolicies(Map<String, Boolean> policies) {
        this.sharedCacheUploadPolicies = policies;
    }

    void createLocalResources(Map<String, LocalResource> localResources) throws IOException {
        if (this.uris != null) {
            if (this.uris.length != this.timestamps.length || this.uris.length != this.sizes.length || this.uris.length != this.visibilities.length) {
                throw new IllegalArgumentException("Invalid specification for distributed-cache artifacts of type " + (Object)((Object)this.type) + " : #uris=" + this.uris.length + " #timestamps=" + this.timestamps.length + " #visibilities=" + this.visibilities.length);
            }
            for (int i = 0; i < this.uris.length; ++i) {
                LocalResource orig;
                URI u = this.uris[i];
                Path p = new Path(u);
                FileSystem remoteFS = p.getFileSystem(this.conf);
                String linkName = null;
                if (p.getName().equals("*")) {
                    p = p.getParent();
                    linkName = p.getName() + "/" + "*";
                }
                p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                if (linkName == null) {
                    linkName = u.getFragment();
                    if (linkName != null) {
                        Path linkPath = new Path(linkName);
                        if (linkPath.isAbsolute()) {
                            throw new IllegalArgumentException("Resource name must be relative");
                        }
                        linkName = linkPath.toUri().getPath();
                    }
                } else if (u.getFragment() != null) {
                    throw new IllegalArgumentException("Invalid path URI: " + p + " - cannot contain both a URI fragment and a wildcard");
                }
                if (linkName == null) {
                    linkName = p.getName();
                }
                if ((orig = localResources.get(linkName)) != null && !orig.getResource().equals(URL.fromURI(p.toUri()))) {
                    LOG.warn(LocalResourceBuilder.getResourceDescription(orig.getType()) + orig.getResource() + " conflicts with " + LocalResourceBuilder.getResourceDescription(this.type) + u);
                    continue;
                }
                Boolean sharedCachePolicy = this.sharedCacheUploadPolicies.get(u.toString());
                sharedCachePolicy = sharedCachePolicy == null ? Boolean.FALSE : sharedCachePolicy;
                localResources.put(linkName, LocalResource.newInstance(URL.fromURI(p.toUri()), this.type, this.visibilities[i] ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE, this.sizes[i], this.timestamps[i], sharedCachePolicy));
            }
        }
    }

    private static String getResourceDescription(LocalResourceType type) {
        if (type == LocalResourceType.ARCHIVE || type == LocalResourceType.PATTERN) {
            return "cache archive (mapreduce.job.cache.archives) ";
        }
        return "cache file (mapreduce.job.cache.files) ";
    }
}

