/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.BasicDiskValidator;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.DiskValidator;
import org.apache.hadoop.util.ReadWriteDiskValidator;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DiskValidatorFactory {
    @VisibleForTesting
    static final ConcurrentHashMap<Class<? extends DiskValidator>, DiskValidator> INSTANCES = new ConcurrentHashMap();

    private DiskValidatorFactory() {
    }

    public static DiskValidator getInstance(Class<? extends DiskValidator> clazz) {
        DiskValidator diskValidator;
        if (INSTANCES.containsKey(clazz)) {
            diskValidator = INSTANCES.get(clazz);
        } else {
            diskValidator = ReflectionUtils.newInstance(clazz, null);
            DiskValidator diskValidatorRet = INSTANCES.putIfAbsent(clazz, diskValidator);
            if (diskValidatorRet != null) {
                diskValidator = diskValidatorRet;
            }
        }
        return diskValidator;
    }

    public static DiskValidator getInstance(String diskValidator) throws DiskChecker.DiskErrorException {
        Class clazz;
        if (diskValidator.equalsIgnoreCase("basic")) {
            clazz = BasicDiskValidator.class;
        } else if (diskValidator.equalsIgnoreCase("read-write")) {
            clazz = ReadWriteDiskValidator.class;
        } else {
            try {
                clazz = Class.forName(diskValidator);
            }
            catch (ClassNotFoundException cnfe) {
                throw new DiskChecker.DiskErrorException(diskValidator + " DiskValidator class not found.", cnfe);
            }
        }
        return DiskValidatorFactory.getInstance(clazz);
    }
}

