/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ContainerReport {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerReport newInstance(ContainerId containerId, Resource allocatedResource, NodeId assignedNode, Priority priority, long creationTime, long finishTime, String diagnosticInfo, String logUrl, int containerExitStatus, ContainerState containerState, String nodeHttpAddress) {
        return ContainerReport.newInstance(containerId, allocatedResource, assignedNode, priority, creationTime, finishTime, diagnosticInfo, logUrl, containerExitStatus, containerState, nodeHttpAddress, ExecutionType.GUARANTEED);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerReport newInstance(ContainerId containerId, Resource allocatedResource, NodeId assignedNode, Priority priority, long creationTime, long finishTime, String diagnosticInfo, String logUrl, int containerExitStatus, ContainerState containerState, String nodeHttpAddress, ExecutionType executionType) {
        ContainerReport report = Records.newRecord(ContainerReport.class);
        report.setContainerId(containerId);
        report.setAllocatedResource(allocatedResource);
        report.setAssignedNode(assignedNode);
        report.setPriority(priority);
        report.setCreationTime(creationTime);
        report.setFinishTime(finishTime);
        report.setDiagnosticsInfo(diagnosticInfo);
        report.setLogUrl(logUrl);
        report.setContainerExitStatus(containerExitStatus);
        report.setContainerState(containerState);
        report.setNodeHttpAddress(nodeHttpAddress);
        report.setExecutionType(executionType);
        return report;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ContainerId getContainerId();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setContainerId(ContainerId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Resource getAllocatedResource();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setAllocatedResource(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract NodeId getAssignedNode();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setAssignedNode(NodeId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Priority getPriority();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getCreationTime();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setCreationTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getFinishTime();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setFinishTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getDiagnosticsInfo();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setDiagnosticsInfo(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getLogUrl();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setLogUrl(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ContainerState getContainerState();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setContainerState(ContainerState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getContainerExitStatus();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setContainerExitStatus(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getExposedPorts();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setExposedPorts(Map<String, List<Map<String, String>>> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getNodeHttpAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeHttpAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ExecutionType getExecutionType();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setExecutionType(ExecutionType var1);
}

