# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/fit_pipeline.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def fit_pipeline(trainData: Frame,
                 testData: Frame,
                 pip: Frame,
                 applyFunc: Frame,
                 hp: Matrix,
                 evaluationFunc: str,
                 evalFunHp: Matrix,
                 **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     This script will read the dirty and clean data, then it will apply the best pipeline on dirty data
     and then will classify both cleaned dataset and check if the cleaned dataset is performing same as original dataset
     in terms of classification accuracy
    
    
    
    :param trainData: ---
    :param testData: ---
    :param metaData: ---
    :param lp: ---
    :param pip: ---
    :param hp: ---
    :param evaluationFunc: ---
    :param evalFunHp: ---
    :param isLastLabel: ---
    :param correctTypos: ---
    :return: ---
    """

    params_dict = {'trainData': trainData, 'testData': testData, 'pip': pip, 'applyFunc': applyFunc, 'hp': hp, 'evaluationFunc': evaluationFunc, 'evalFunHp': evalFunHp}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(trainData.sds_context, '')
    vX_1 = Matrix(trainData.sds_context, '')
    vX_2 = Matrix(trainData.sds_context, '')
    vX_3 = List(trainData.sds_context, '')
    vX_4 = List(trainData.sds_context, '')
    output_nodes = [vX_0, vX_1, vX_2, vX_3, vX_4, ]

    op = MultiReturn(trainData.sds_context, 'fit_pipeline', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]
    vX_2._unnamed_input_nodes = [op]
    vX_3._unnamed_input_nodes = [op]
    vX_4._unnamed_input_nodes = [op]

    return op
