# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/lmPredict.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def lmPredict(X: Matrix,
              B: Matrix,
              **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     The lmPredict-function predicts the class of a feature vector
    
    
    
    :param X: Matrix of feature vectors
    :param B: 1-column matrix of weights.
    :param ytest: test labels, used only for verbose output. can be set to matrix(0,1,1)
        if verbose output is not wanted
    :param icpt: Intercept presence, shifting and rescaling the columns of X
    :param verbose: If TRUE print messages are activated
    :return: 1-column matrix of classes
    """

    params_dict = {'X': X, 'B': B}
    params_dict.update(kwargs)
    return Matrix(X.sds_context,
        'lmPredict',
        named_input_nodes=params_dict)
