# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/normalizeApply.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def normalizeApply(X: Matrix,
                   cmin: Matrix,
                   cmax: Matrix):
    """
     Min-max normalization (a.k.a. min-max scaling) to range [0,1], given 
     existing min-max ranges. For matrices of positive values, this normalization 
     preserves the input sparsity. The validity of the provided min-max range
     and post-processing is under control of the caller. 
    
    
    
    :param X: Input feature matrix of shape n-by-m
    :param cmin: Colunm minima of shape 1-by-m
    :param cmax: Column maxima of shape 1-by-m
    :return: Modified output feature matrix of shape n-by-m
    """

    params_dict = {'X': X, 'cmin': cmin, 'cmax': cmax}
    return Matrix(X.sds_context,
        'normalizeApply',
        named_input_nodes=params_dict)
