/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class RangeIndex
extends AColIndex {
    private final int l;
    private final int u;

    public RangeIndex(int nCol) {
        this.l = 0;
        this.u = nCol;
    }

    public RangeIndex(int l, int u) {
        this.l = l;
        this.u = u;
    }

    @Override
    public int size() {
        return this.u - this.l;
    }

    @Override
    public int get(int i) {
        return this.l + i;
    }

    @Override
    public IColIndex shift(int i) {
        return new RangeIndex(this.l + i, this.u + i);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(IColIndex.ColIndexType.RANGE.ordinal());
        out.writeInt(this.l);
        out.writeInt(this.u);
    }

    public static RangeIndex read(DataInput in) throws IOException {
        int l = in.readInt();
        int u = in.readInt();
        return new RangeIndex(l, u);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9L;
    }

    @Override
    public long estimateInMemorySize() {
        return RangeIndex.estimateInMemorySizeStatic();
    }

    public static long estimateInMemorySizeStatic() {
        return 24L;
    }

    @Override
    public IIterate iterator() {
        return new RangeIterator();
    }

    @Override
    public int findIndex(int i) {
        if (i < this.l) {
            return -1;
        }
        if (i < this.u) {
            return i - this.l;
        }
        return -1 * this.u - 1 + this.l;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        if (u <= this.l) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        if (l >= this.u) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        if (l <= this.l && u >= this.u) {
            return new IColIndex.SliceResult(0, this.size(), new RangeIndex(this.l - l, this.u - l));
        }
        int offL = Math.max(l, this.l) - this.l;
        int offR = Math.min(u, this.u) - this.l;
        return new IColIndex.SliceResult(offL, offR, new RangeIndex(Math.max(l, this.l) - l, Math.min(u, this.u) - l));
    }

    @Override
    public boolean equals(IColIndex other) {
        if (other instanceof RangeIndex) {
            RangeIndex ot = (RangeIndex)other;
            return ot.l == this.l && ot.u == this.u;
        }
        return other.equals(this);
    }

    @Override
    public IColIndex combine(IColIndex other) {
        if (other.size() == 1) {
            int v = other.get(0);
            if (v + 1 == this.l) {
                return new RangeIndex(this.l - 1, this.u);
            }
            if (v == this.u) {
                return new RangeIndex(this.l, this.u + 1);
            }
        }
        int sr = other.size();
        int sl = this.size();
        int[] ret = new int[sr + sl];
        int pl = 0;
        int pr = 0;
        int i = 0;
        while (pl < sl && pr < sr) {
            int vr;
            int vl = this.get(pl);
            if (vl < (vr = other.get(pr))) {
                ret[i++] = vl;
                ++pl;
                continue;
            }
            ret[i++] = vr;
            ++pr;
        }
        while (pl < sl) {
            ret[i++] = this.get(pl++);
        }
        while (pr < sr) {
            ret[i++] = other.get(pr++);
        }
        return ColIndexFactory.create(ret);
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(this.l);
        sb.append(" -> ");
        sb.append(this.u);
        sb.append("]");
        return sb.toString();
    }

    protected static boolean isValidRange(int[] indexes) {
        int last = indexes[indexes.length - 1];
        int first = indexes[0];
        int len = indexes.length;
        return last - first + 1 == len;
    }

    protected static boolean isValidRange(IntArrayList indexes) {
        int len = indexes.size();
        int first = indexes.get(0);
        int last = indexes.get(indexes.size() - 1);
        return last - first + 1 == len;
    }

    protected class RangeIterator
    implements IIterate {
        int cl;

        protected RangeIterator() {
            this.cl = RangeIndex.this.l;
        }

        @Override
        public int next() {
            return this.cl++;
        }

        @Override
        public boolean hasNext() {
            return this.cl < RangeIndex.this.u;
        }
    }
}

