/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToCharPByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToInt
extends AMapToData {
    private static final long serialVersionUID = -5557070920888782274L;
    private final int[] _data;

    protected MapToInt(int size) {
        this(65536, size);
    }

    public MapToInt(int unique, int size) {
        super(unique);
        this._data = new int[size];
    }

    private MapToInt(int unique, int[] data) {
        super(unique);
        this._data = data;
    }

    protected int[] getData() {
        return this._data;
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.INT;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, v);
    }

    @Override
    public long getInMemorySize() {
        return MapToInt.getInMemorySize(this._data.length);
    }

    protected static long getInMemorySize(int dataLength) {
        long size = 24L;
        size = (long)((double)size + MemoryEstimates.intArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length * 4;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = v;
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = v;
        return this._data[n];
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void replace(int v, int r) {
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != v) continue;
            this._data[i] = r;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.INT.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    protected static MapToInt readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readInt();
        }
        return new MapToInt(unique, data);
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this._data[rc];
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            int n = this._data[rc];
            preAV[n] = preAV[n] + mV[off];
            int n2 = this._data[rc + 1];
            preAV[n2] = preAV[n2] + mV[off + 1];
            int n3 = this._data[rc + 2];
            preAV[n3] = preAV[n3] + mV[off + 2];
            int n4 = this._data[rc + 3];
            preAV[n4] = preAV[n4] + mV[off + 3];
            int n5 = this._data[rc + 4];
            preAV[n5] = preAV[n5] + mV[off + 4];
            int n6 = this._data[rc + 5];
            preAV[n6] = preAV[n6] + mV[off + 5];
            int n7 = this._data[rc + 6];
            preAV[n7] = preAV[n7] + mV[off + 6];
            int n8 = this._data[rc + 7];
            preAV[n8] = preAV[n8] + mV[off + 7];
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseMultiRowContiguousBy8(double[] mV, int nCol, int nVal, double[] preAV, int rl, int ru, int cl, int cu) {
        int h = (cu - cl) % 8;
        this.preAggregateDenseMultiRowContiguousBy1(mV, nCol, nVal, preAV, rl, ru, cl, cl + h);
        int offR = nCol * rl;
        int offE = nCol * ru;
        for (int c = cl + h; c < cu; c += 8) {
            int id1 = this._data[c];
            int id2 = this._data[c + 1];
            int id3 = this._data[c + 2];
            int id4 = this._data[c + 3];
            int id5 = this._data[c + 4];
            int id6 = this._data[c + 5];
            int id7 = this._data[c + 6];
            int id8 = this._data[c + 7];
            int start = c + offR;
            int end = c + offE;
            int nValOff = 0;
            for (int off = start; off < end; off += nCol) {
                int n = id1 + nValOff;
                preAV[n] = preAV[n] + mV[off];
                int n2 = id2 + nValOff;
                preAV[n2] = preAV[n2] + mV[off + 1];
                int n3 = id3 + nValOff;
                preAV[n3] = preAV[n3] + mV[off + 2];
                int n4 = id4 + nValOff;
                preAV[n4] = preAV[n4] + mV[off + 3];
                int n5 = id5 + nValOff;
                preAV[n5] = preAV[n5] + mV[off + 4];
                int n6 = id6 + nValOff;
                preAV[n6] = preAV[n6] + mV[off + 5];
                int n7 = id7 + nValOff;
                preAV[n7] = preAV[n7] + mV[off + 6];
                int n8 = id8 + nValOff;
                preAV[n8] = preAV[n8] + mV[off + 7];
                nValOff += nVal;
            }
        }
    }

    @Override
    public int getUpperBoundValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void copyInt(int[] d) {
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = d[i];
        }
    }

    @Override
    public void copyBit(BitSet d) {
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this._data[i] = 1;
            i = d.nextSetBit(i + 1);
        }
    }

    @Override
    public int[] getCounts(int[] ret) {
        for (int i = 0; i < this._data.length; ++i) {
            int n = this._data[i];
            ret[n] = ret[n] + 1;
        }
        return ret;
    }

    @Override
    public int countRuns() {
        int c = 1;
        int prev = this._data[0];
        for (int i = 1; i < this._data.length; ++i) {
            c += prev == this._data[i] ? 0 : 1;
            prev = this._data[i];
        }
        return c;
    }

    @Override
    public AMapToData resize(int unique) {
        AMapToData ret;
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            ret = new MapToBit(unique, size);
        } else if (unique <= 127) {
            ret = new MapToUByte(unique, size);
        } else if (unique < 256) {
            ret = new MapToByte(unique, size);
        } else if (unique < 65534) {
            ret = new MapToChar(unique, size);
        } else if (unique < 8322945) {
            ret = new MapToCharPByte(unique, size);
        } else {
            this.setUnique(unique);
            return this;
        }
        ((AMapToData)ret).copyInt(this._data);
        return ret;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToInt(this.getUnique(), Arrays.copyOfRange(this._data, l, u));
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToInt) {
            MapToInt tb = (MapToInt)t;
            int[] tbb = tb._data;
            int newSize = this._data.length + t.size();
            int newDistinct = Math.max(this.getUnique(), t.getUnique());
            int[] ret = Arrays.copyOf(this._data, newSize);
            System.arraycopy(tbb, 0, ret, this._data.length, t.size());
            return new MapToInt(newDistinct, ret);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(AMapToDataGroup[] d) {
        int p = 0;
        for (AMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        int[] ret = Arrays.copyOf(this._data, p);
        p = this.size();
        for (int i = 1; i < d.length; ++i) {
            MapToInt mm = (MapToInt)d[i].getMapToData();
            int ms = mm.size();
            System.arraycopy(mm._data, 0, ret, p, ms);
            p += ms;
        }
        return new MapToInt(this.getUnique(), ret);
    }
}

