/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.homomorphicEncryption;

import java.util.stream.IntStream;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.paramserv.NativeHEHelper;
import org.apache.sysds.runtime.controlprogram.paramserv.homomorphicEncryption.PublicKey;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.instructions.cp.CiphertextMatrix;
import org.apache.sysds.runtime.instructions.cp.PlaintextMatrix;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class SEALClient {
    private final long ctx;

    public SEALClient(byte[] a) {
        this.ctx = NativeHEHelper.initClient(a);
    }

    public PublicKey generatePartialPublicKey() {
        return new PublicKey(NativeHEHelper.generatePartialPublicKey(this.ctx));
    }

    public void setPublicKey(PublicKey public_key) {
        NativeHEHelper.setPublicKey(this.ctx, public_key.getData());
    }

    public CiphertextMatrix encrypt(MatrixObject plaintext) {
        MatrixBlock mb = (MatrixBlock)plaintext.acquireReadAndRelease();
        if (mb.isInSparseFormat()) {
            mb.allocateSparseRowsBlock();
            mb.sparseToDense();
        }
        DenseBlock db = mb.getDenseBlock();
        int[] dims = IntStream.range(0, db.numDims()).map(db::getDim).toArray();
        double[] raw_data = mb.getDenseBlockValues();
        return new CiphertextMatrix(dims, plaintext.getDataCharacteristics(), NativeHEHelper.encrypt(this.ctx, raw_data));
    }

    public PlaintextMatrix partiallyDecrypt(CiphertextMatrix ciphertext) {
        return new PlaintextMatrix(ciphertext.getDims(), ciphertext.getDataCharacteristics(), NativeHEHelper.partiallyDecrypt(this.ctx, ciphertext.getData()));
    }
}

