/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.concurrent.Executors;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.CPInstructionParser;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstructionUtils;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysds.runtime.instructions.gpu.context.GPUMemoryEviction;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageGPUCacheEviction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.privacy.propagation.PrivacyPropagator;

public abstract class CPInstruction
extends Instruction {
    protected final CPType _cptype;
    protected final boolean _requiresLabelUpdate;

    protected CPInstruction(CPType type, String opcode, String istr) {
        this(type, null, opcode, istr);
    }

    protected CPInstruction(CPType type, Operator op, String opcode, String istr) {
        super(op);
        this._cptype = type;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    @Override
    public Instruction.IType getType() {
        return Instruction.IType.CONTROL_PROGRAM;
    }

    public CPType getCPInstructionType() {
        return this._cptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) {
        long almostFull;
        long availableMem;
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = CPInstruction.updateLabels(tmp.toString(), ec.getVariables());
            tmp = CPInstructionParser.parseSingleInstruction(updInst);
            if (DMLScript.LINEAGE) {
                ec.traceLineage(tmp);
            }
        }
        if (ConfigurationManager.isFederatedRuntimePlanner()) {
            tmp = FEDInstructionUtils.checkAndReplaceCP(tmp, ec);
        }
        tmp = PrivacyPropagator.preprocessInstruction(tmp, ec);
        if (!LineageCacheConfig.ReuseCacheType.isNone() && DMLScript.USE_ACCELERATOR && LineageCacheConfig.CONCURRENTGPUEVICTION && ec.getNumGPUContexts() > 0 && !(tmp instanceof VariableCPInstruction) && !(tmp instanceof FunctionCallCPInstruction) && (availableMem = ec.getGPUContext(0).getAvailableMemory()) < (almostFull = (long)(0.2 * (double)GPUContextPool.initialGPUMemBudget()))) {
            if (LineageGPUCacheEviction.gpuEvictionThread == null) {
                LineageGPUCacheEviction.gpuEvictionThread = Executors.newSingleThreadExecutor();
            }
            LineageCacheConfig.STOPBACKGROUNDEVICTION = false;
            LineageGPUCacheEviction.gpuEvictionThread.submit(new GPUMemoryEviction());
        }
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1);

    public static String updateLabels(String instList, LocalVariableMap labelValueMapping) {
        if (!instList.contains("\u00b6")) {
            return instList;
        }
        StringBuilder updateInstList = new StringBuilder();
        String[] ilist = instList.split("\u2021");
        for (int i = 0; i < ilist.length; ++i) {
            if (i > 0) {
                updateInstList.append("\u2021");
            }
            updateInstList.append(CPInstruction.updateInstLabels(ilist[i], labelValueMapping));
        }
        return updateInstList.toString();
    }

    @Override
    public void postprocessInstruction(ExecutionContext ec) {
        if (!LineageCacheConfig.ReuseCacheType.isNone() && DMLScript.USE_ACCELERATOR && LineageCacheConfig.CONCURRENTGPUEVICTION) {
            LineageCacheConfig.STOPBACKGROUNDEVICTION = true;
        }
        if (DMLScript.LINEAGE_DEBUGGER) {
            ec.maintainLineageDebuggerInfo(this);
        }
    }

    private static String updateInstLabels(String inst, LocalVariableMap map) {
        if (inst.contains("\u00b6")) {
            int skip = "\u00b6".length();
            while (inst.contains("\u00b6")) {
                int startLoc = inst.indexOf("\u00b6") + skip;
                String varName = inst.substring(startLoc, inst.indexOf("\u00b6", startLoc));
                String replacement = CPInstruction.getVarNameReplacement(inst, varName, map);
                inst = inst.replaceAll("\u00b6" + varName + "\u00b6", replacement);
            }
        }
        return inst;
    }

    private static String getVarNameReplacement(String inst, String varName, LocalVariableMap map) {
        Data val = map.get(varName);
        if (val != null) {
            Object replacement = null;
            if (val.getDataType() == Types.DataType.MATRIX) {
                replacement = ((MatrixObject)val).getFileName();
            }
            if (val.getDataType() == Types.DataType.SCALAR) {
                replacement = ((ScalarObject)val).getStringValue();
            }
            return replacement;
        }
        throw new DMLRuntimeException("Variable (" + varName + ") in Instruction (" + inst + ") is not found in the variablemap.");
    }

    public static enum CPType {
        AggregateUnary,
        AggregateBinary,
        AggregateTernary,
        Unary,
        Binary,
        Ternary,
        Quaternary,
        BuiltinNary,
        Ctable,
        MultiReturnParameterizedBuiltin,
        ParameterizedBuiltin,
        MultiReturnBuiltin,
        Builtin,
        Reorg,
        Variable,
        FCall,
        Append,
        Rand,
        QSort,
        QPick,
        Local,
        MatrixIndexing,
        MMTSJ,
        PMMJ,
        MMChain,
        Reshape,
        Partition,
        Compression,
        DeCompression,
        SpoofFused,
        StringInit,
        CentralMoment,
        Covariance,
        UaggOuterChain,
        Dnn,
        Sql,
        Prefetch,
        Broadcast,
        TrigRemote;

    }
}

