/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.utils.GPUStatistics;

public class MatrixAppendGPUInstruction
extends GPUInstruction {
    AppendCPInstruction.AppendType atype;

    private MatrixAppendGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, AppendCPInstruction.AppendType type, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this.atype = type;
    }

    public static MatrixAppendGPUInstruction parseInstruction(String str) {
        AppendCPInstruction.AppendType type;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        boolean cbind = Boolean.parseBoolean(parts[5]);
        AppendCPInstruction.AppendType appendType = in1.getDataType() != Types.DataType.MATRIX && in1.getDataType() != Types.DataType.FRAME ? AppendCPInstruction.AppendType.STRING : (type = cbind ? AppendCPInstruction.AppendType.CBIND : AppendCPInstruction.AppendType.RBIND);
        if (in1.getDataType() != Types.DataType.MATRIX || in2.getDataType() != Types.DataType.MATRIX) {
            throw new DMLRuntimeException("GPU : Error in internal state - Append was called on data other than matrices");
        }
        if (!opcode.equalsIgnoreCase("append")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendCPInstruction: " + str);
        }
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        return new MatrixAppendGPUInstruction(op, in1, in2, out, type, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        MatrixObject mat1 = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        MatrixObject mat2 = this.getMatrixInputForGPUInstruction(ec, this._input2.getName());
        if (this.atype == AppendCPInstruction.AppendType.CBIND) {
            LibMatrixCUDA.cbind(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat1, mat2, this._output.getName());
        } else if (this.atype == AppendCPInstruction.AppendType.RBIND) {
            LibMatrixCUDA.rbind(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat1, mat2, this._output.getName());
        } else {
            throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
        }
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input2.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

