/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.Iterator;
import org.apache.sysds.runtime.util.UtilFunctions;

public class LongLongDoubleHashMap {
    private static final int INIT_CAPACITY = 8;
    private static final int RESIZE_FACTOR = 2;
    private static final float LOAD_FACTOR = 0.75f;
    private final EntryType type;
    private ADoubleEntry[] data = null;
    private int size = -1;

    public LongLongDoubleHashMap() {
        this(EntryType.LONG);
    }

    public LongLongDoubleHashMap(EntryType etype) {
        this.type = etype;
        this.data = new ADoubleEntry[8];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int getNonZeros() {
        int ret = 0;
        for (ADoubleEntry e : this.data) {
            while (e != null) {
                ret += e.value != 0.0 ? 1 : 0;
                e = e.next;
            }
        }
        return ret;
    }

    public void addValue(long key1, long key2, double value) {
        int ix = LongLongDoubleHashMap.getIndex(key1, key2, this.data.length);
        ADoubleEntry e = this.data[ix];
        while (e != null) {
            if (e.getKey1() == key1 && e.getKey2() == key2) {
                e.value += value;
                return;
            }
            e = e.next;
        }
        ADoubleEntry enew = this.type == EntryType.LONG ? new LLDoubleEntry(key1, key2, value) : new IIDoubleEntry(key1, key2, value);
        enew.next = this.data[ix];
        this.data[ix] = enew;
        ++this.size;
        if ((float)this.size >= 0.75f * (float)this.data.length) {
            this.resize();
        }
    }

    public Iterator<ADoubleEntry> getIterator() {
        return new ADoubleEntryIterator();
    }

    private void resize() {
        if (this.data.length > 0x3FFFFFFF) {
            return;
        }
        ADoubleEntry[] olddata = this.data;
        this.data = new ADoubleEntry[this.data.length * 2];
        this.size = 0;
        for (ADoubleEntry e : olddata) {
            if (e == null) continue;
            while (e.next != null) {
                ADoubleEntry tmp = e;
                e = e.next;
                this.appendEntry(tmp.getKey1(), tmp.getKey2(), tmp);
            }
            this.appendEntry(e.getKey1(), e.getKey2(), e);
        }
    }

    private void appendEntry(long key1, long key2, ADoubleEntry e) {
        int ix = LongLongDoubleHashMap.getIndex(key1, key2, this.data.length);
        e.next = this.data[ix];
        this.data[ix] = e;
        ++this.size;
    }

    private static int getIndex(long key1, long key2, int length) {
        int hash = LongLongDoubleHashMap.hash(key1, key2);
        return LongLongDoubleHashMap.indexFor(hash, length);
    }

    private static int hash(long key1, long key2) {
        int h = UtilFunctions.longHashCode(key1, key2);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private class ADoubleEntryIterator
    implements Iterator<ADoubleEntry> {
        private ADoubleEntry _curr = null;
        private int _currPos = -1;

        public ADoubleEntryIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this._curr != null;
        }

        @Override
        public ADoubleEntry next() {
            ADoubleEntry ret = this._curr;
            this.findNext();
            return ret;
        }

        private void findNext() {
            if (this._curr != null && this._curr.next != null) {
                this._curr = this._curr.next;
                return;
            }
            ++this._currPos;
            while (this._currPos < LongLongDoubleHashMap.this.data.length) {
                this._curr = LongLongDoubleHashMap.this.data[this._currPos];
                if (this._curr != null) {
                    return;
                }
                ++this._currPos;
            }
            this._curr = null;
        }
    }

    private static class IIDoubleEntry
    extends ADoubleEntry {
        private final int key1;
        private final int key2;

        public IIDoubleEntry(long k1, long k2, double val) {
            super(val);
            this.key1 = (int)k1;
            this.key2 = (int)k2;
        }

        @Override
        public long getKey1() {
            return this.key1;
        }

        @Override
        public long getKey2() {
            return this.key2;
        }
    }

    private static class LLDoubleEntry
    extends ADoubleEntry {
        private final long key1;
        private final long key2;

        public LLDoubleEntry(long k1, long k2, double val) {
            super(val);
            this.key1 = k1;
            this.key2 = k2;
        }

        @Override
        public long getKey1() {
            return this.key1;
        }

        @Override
        public long getKey2() {
            return this.key2;
        }
    }

    public static abstract class ADoubleEntry {
        public double value = Double.MAX_VALUE;
        public ADoubleEntry next = null;

        public ADoubleEntry(double val) {
            this.value = val;
            this.next = null;
        }

        public abstract long getKey1();

        public abstract long getKey2();
    }

    public static enum EntryType {
        LONG,
        INT;

    }
}

