/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils.stats;

import java.util.concurrent.atomic.LongAdder;

public class RecompileStatistics {
    private static final LongAdder recompileTime = new LongAdder();
    private static final LongAdder recompilePred = new LongAdder();
    private static final LongAdder recompileSB = new LongAdder();

    public static void incrementRecompileTime(long delta) {
        recompileTime.add(delta);
    }

    public static void incrementRecompilePred() {
        recompilePred.increment();
    }

    public static void incrementRecompilePred(long delta) {
        recompilePred.add(delta);
    }

    public static void incrementRecompileSB() {
        recompileSB.increment();
    }

    public static void incrementRecompileSB(long delta) {
        recompileSB.add(delta);
    }

    public static long getRecompileTime() {
        return recompileTime.longValue();
    }

    public static long getRecompiledPredDAGs() {
        return recompilePred.longValue();
    }

    public static long getRecompiledSBDAGs() {
        return recompileSB.longValue();
    }

    public static void reset() {
        recompileTime.reset();
        recompilePred.reset();
        recompileSB.reset();
    }

    public static String displayStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("HOP DAGs recompiled (PRED, SB):\t" + RecompileStatistics.getRecompiledPredDAGs() + "/" + RecompileStatistics.getRecompiledSBDAGs() + ".\n");
        sb.append("HOP DAGs recompile time:\t" + String.format("%.3f", (double)RecompileStatistics.getRecompileTime() / 1.0E9) + " sec.\n");
        return sb.toString();
    }
}

