/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcusolver;

import jcuda.Pointer;
import jcuda.cuComplex;
import jcuda.cuDoubleComplex;
import jcuda.jcusolver.JCusolver;
import jcuda.jcusolver.csrqrInfo;
import jcuda.jcusolver.cusolverSpHandle;
import jcuda.jcusparse.cusparseMatDescr;
import jcuda.runtime.cudaStream_t;

public class JCusolverSp {
    private JCusolverSp() {
    }

    private static int checkResult(int result) {
        return JCusolver.checkResult(result);
    }

    public static int cusolverSpCreate(cusolverSpHandle handle) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCreateNative(handle));
    }

    private static native int cusolverSpCreateNative(cusolverSpHandle var0);

    public static int cusolverSpDestroy(cusolverSpHandle handle) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDestroyNative(handle));
    }

    private static native int cusolverSpDestroyNative(cusolverSpHandle var0);

    public static int cusolverSpSetStream(cusolverSpHandle handle, cudaStream_t streamId) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpSetStreamNative(handle, streamId));
    }

    private static native int cusolverSpSetStreamNative(cusolverSpHandle var0, cudaStream_t var1);

    public static int cusolverSpGetStream(cusolverSpHandle handle, cudaStream_t streamId) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpGetStreamNative(handle, streamId));
    }

    private static native int cusolverSpGetStreamNative(cusolverSpHandle var0, cudaStream_t var1);

    public static int cusolverSpXcsrissymHost(cusolverSpHandle handle, int m, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrEndPtrA, Pointer csrColIndA, Pointer issym) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrissymHostNative(handle, m, nnzA, descrA, csrRowPtrA, csrEndPtrA, csrColIndA, issym));
    }

    private static native int cusolverSpXcsrissymHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusolverSpScsrlsvluHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrlsvluHostNative(handle, n, nnzA, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpScsrlsvluHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpDcsrlsvluHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrlsvluHostNative(handle, n, nnzA, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpDcsrlsvluHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpCcsrlsvluHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrlsvluHostNative(handle, n, nnzA, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpCcsrlsvluHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpZcsrlsvluHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrlsvluHostNative(handle, n, nnzA, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpZcsrlsvluHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpScsrlsvqr(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrlsvqrNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpScsrlsvqrNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpDcsrlsvqr(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrlsvqrNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpDcsrlsvqrNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpCcsrlsvqr(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrlsvqrNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpCcsrlsvqrNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpZcsrlsvqr(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrlsvqrNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpZcsrlsvqrNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpScsrlsvqrHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrlsvqrHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpScsrlsvqrHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpDcsrlsvqrHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrlsvqrHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpDcsrlsvqrHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpCcsrlsvqrHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrlsvqrHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpCcsrlsvqrHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpZcsrlsvqrHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrlsvqrHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpZcsrlsvqrHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpScsrlsvcholHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrlsvcholHostNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpScsrlsvcholHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpDcsrlsvcholHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrlsvcholHostNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpDcsrlsvcholHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpCcsrlsvcholHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrlsvcholHostNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpCcsrlsvcholHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpZcsrlsvcholHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrlsvcholHostNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpZcsrlsvcholHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpScsrlsvchol(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrlsvcholNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpScsrlsvcholNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpDcsrlsvchol(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrlsvcholNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpDcsrlsvcholNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpCcsrlsvchol(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, float tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrlsvcholNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpCcsrlsvcholNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, float var8, int var9, Pointer var10, int[] var11);

    public static int cusolverSpZcsrlsvchol(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer b, double tol, int reorder, Pointer x, int[] singularity) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrlsvcholNative(handle, m, nnz, descrA, csrVal, csrRowPtr, csrColInd, b, tol, reorder, x, singularity));
    }

    private static native int cusolverSpZcsrlsvcholNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, double var8, int var10, Pointer var11, int[] var12);

    public static int cusolverSpScsrlsqvqrHost(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, float tol, Pointer rankA, Pointer x, Pointer p, Pointer min_norm) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrlsqvqrHostNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, rankA, x, p, min_norm));
    }

    private static native int cusolverSpScsrlsqvqrHostNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, float var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusolverSpDcsrlsqvqrHost(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, double tol, Pointer rankA, Pointer x, Pointer p, Pointer min_norm) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrlsqvqrHostNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, rankA, x, p, min_norm));
    }

    private static native int cusolverSpDcsrlsqvqrHostNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, double var9, Pointer var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusolverSpCcsrlsqvqrHost(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, float tol, Pointer rankA, Pointer x, Pointer p, Pointer min_norm) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrlsqvqrHostNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, rankA, x, p, min_norm));
    }

    private static native int cusolverSpCcsrlsqvqrHostNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, float var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusolverSpZcsrlsqvqrHost(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, double tol, Pointer rankA, Pointer x, Pointer p, Pointer min_norm) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrlsqvqrHostNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, tol, rankA, x, p, min_norm));
    }

    private static native int cusolverSpZcsrlsqvqrHostNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, double var9, Pointer var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusolverSpScsreigvsiHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, float mu0, Pointer x0, int maxite, float tol, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsreigvsiHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, tol, mu, x));
    }

    private static native int cusolverSpScsreigvsiHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, float var7, Pointer var8, int var9, float var10, Pointer var11, Pointer var12);

    public static int cusolverSpDcsreigvsiHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, double mu0, Pointer x0, int maxite, double tol, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsreigvsiHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, tol, mu, x));
    }

    private static native int cusolverSpDcsreigvsiHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, double var7, Pointer var9, int var10, double var11, Pointer var13, Pointer var14);

    public static int cusolverSpCcsreigvsiHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuComplex mu0, Pointer x0, int maxite, float tol, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsreigvsiHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, tol, mu, x));
    }

    private static native int cusolverSpCcsreigvsiHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuComplex var7, Pointer var8, int var9, float var10, Pointer var11, Pointer var12);

    public static int cusolverSpZcsreigvsiHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuDoubleComplex mu0, Pointer x0, int maxite, double tol, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsreigvsiHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, tol, mu, x));
    }

    private static native int cusolverSpZcsreigvsiHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuDoubleComplex var7, Pointer var8, int var9, double var10, Pointer var12, Pointer var13);

    public static int cusolverSpScsreigvsi(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, float mu0, Pointer x0, int maxite, float eps, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsreigvsiNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, eps, mu, x));
    }

    private static native int cusolverSpScsreigvsiNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, float var7, Pointer var8, int var9, float var10, Pointer var11, Pointer var12);

    public static int cusolverSpDcsreigvsi(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, double mu0, Pointer x0, int maxite, double eps, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsreigvsiNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, eps, mu, x));
    }

    private static native int cusolverSpDcsreigvsiNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, double var7, Pointer var9, int var10, double var11, Pointer var13, Pointer var14);

    public static int cusolverSpCcsreigvsi(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuComplex mu0, Pointer x0, int maxite, float eps, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsreigvsiNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, eps, mu, x));
    }

    private static native int cusolverSpCcsreigvsiNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuComplex var7, Pointer var8, int var9, float var10, Pointer var11, Pointer var12);

    public static int cusolverSpZcsreigvsi(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuDoubleComplex mu0, Pointer x0, int maxite, double eps, Pointer mu, Pointer x) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsreigvsiNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, mu0, x0, maxite, eps, mu, x));
    }

    private static native int cusolverSpZcsreigvsiNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuDoubleComplex var7, Pointer var8, int var9, double var10, Pointer var12, Pointer var13);

    public static int cusolverSpScsreigsHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuComplex left_bottom_corner, cuComplex right_upper_corner, Pointer num_eigs) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsreigsHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, left_bottom_corner, right_upper_corner, num_eigs));
    }

    private static native int cusolverSpScsreigsHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuComplex var7, cuComplex var8, Pointer var9);

    public static int cusolverSpDcsreigsHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuDoubleComplex left_bottom_corner, cuDoubleComplex right_upper_corner, Pointer num_eigs) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsreigsHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, left_bottom_corner, right_upper_corner, num_eigs));
    }

    private static native int cusolverSpDcsreigsHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuDoubleComplex var7, cuDoubleComplex var8, Pointer var9);

    public static int cusolverSpCcsreigsHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuComplex left_bottom_corner, cuComplex right_upper_corner, Pointer num_eigs) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsreigsHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, left_bottom_corner, right_upper_corner, num_eigs));
    }

    private static native int cusolverSpCcsreigsHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuComplex var7, cuComplex var8, Pointer var9);

    public static int cusolverSpZcsreigsHost(cusolverSpHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cuDoubleComplex left_bottom_corner, cuDoubleComplex right_upper_corner, Pointer num_eigs) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsreigsHostNative(handle, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, left_bottom_corner, right_upper_corner, num_eigs));
    }

    private static native int cusolverSpZcsreigsHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cuDoubleComplex var7, cuDoubleComplex var8, Pointer var9);

    public static int cusolverSpXcsrsymrcmHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer p) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrsymrcmHostNative(handle, n, nnzA, descrA, csrRowPtrA, csrColIndA, p));
    }

    private static native int cusolverSpXcsrsymrcmHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6);

    public static int cusolverSpXcsrsymmdqHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer p) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrsymmdqHostNative(handle, n, nnzA, descrA, csrRowPtrA, csrColIndA, p));
    }

    private static native int cusolverSpXcsrsymmdqHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6);

    public static int cusolverSpXcsrsymamdHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer p) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrsymamdHostNative(handle, n, nnzA, descrA, csrRowPtrA, csrColIndA, p));
    }

    private static native int cusolverSpXcsrsymamdHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6);

    public static int cusolverSpXcsrmetisndHost(cusolverSpHandle handle, int n, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, long[] options, Pointer p) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrmetisndHostNative(handle, n, nnzA, descrA, csrRowPtrA, csrColIndA, options, p));
    }

    private static native int cusolverSpXcsrmetisndHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, long[] var6, Pointer var7);

    public static int cusolverSpScsrzfdHost(cusolverSpHandle handle, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer P, Pointer numnz) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrzfdHostNative(handle, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, P, numnz));
    }

    private static native int cusolverSpScsrzfdHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusolverSpDcsrzfdHost(cusolverSpHandle handle, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer P, Pointer numnz) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrzfdHostNative(handle, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, P, numnz));
    }

    private static native int cusolverSpDcsrzfdHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusolverSpCcsrzfdHost(cusolverSpHandle handle, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer P, Pointer numnz) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrzfdHostNative(handle, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, P, numnz));
    }

    private static native int cusolverSpCcsrzfdHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusolverSpZcsrzfdHost(cusolverSpHandle handle, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer P, Pointer numnz) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrzfdHostNative(handle, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, P, numnz));
    }

    private static native int cusolverSpZcsrzfdHostNative(cusolverSpHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusolverSpXcsrperm_bufferSizeHost(cusolverSpHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer p, Pointer q, long[] bufferSizeInBytes) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrperm_bufferSizeHostNative(handle, m, n, nnzA, descrA, csrRowPtrA, csrColIndA, p, q, bufferSizeInBytes));
    }

    private static native int cusolverSpXcsrperm_bufferSizeHostNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, long[] var9);

    public static int cusolverSpXcsrpermHost(cusolverSpHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer p, Pointer q, Pointer map, Pointer pBuffer) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrpermHostNative(handle, m, n, nnzA, descrA, csrRowPtrA, csrColIndA, p, q, map, pBuffer));
    }

    private static native int cusolverSpXcsrpermHostNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10);

    public static int cusolverSpCreateCsrqrInfo(csrqrInfo info) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCreateCsrqrInfoNative(info));
    }

    private static native int cusolverSpCreateCsrqrInfoNative(csrqrInfo var0);

    public static int cusolverSpDestroyCsrqrInfo(csrqrInfo info) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDestroyCsrqrInfoNative(info));
    }

    private static native int cusolverSpDestroyCsrqrInfoNative(csrqrInfo var0);

    public static int cusolverSpXcsrqrAnalysisBatched(cusolverSpHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, csrqrInfo info) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpXcsrqrAnalysisBatchedNative(handle, m, n, nnzA, descrA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusolverSpXcsrqrAnalysisBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, csrqrInfo var7);

    public static int cusolverSpScsrqrBufferInfoBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, int batchSize, csrqrInfo info, long[] internalDataInBytes, long[] workspaceInBytes) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrqrBufferInfoBatchedNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, batchSize, info, internalDataInBytes, workspaceInBytes));
    }

    private static native int cusolverSpScsrqrBufferInfoBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, csrqrInfo var9, long[] var10, long[] var11);

    public static int cusolverSpDcsrqrBufferInfoBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, int batchSize, csrqrInfo info, long[] internalDataInBytes, long[] workspaceInBytes) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrqrBufferInfoBatchedNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, batchSize, info, internalDataInBytes, workspaceInBytes));
    }

    private static native int cusolverSpDcsrqrBufferInfoBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, csrqrInfo var9, long[] var10, long[] var11);

    public static int cusolverSpCcsrqrBufferInfoBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, int batchSize, csrqrInfo info, long[] internalDataInBytes, long[] workspaceInBytes) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrqrBufferInfoBatchedNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, batchSize, info, internalDataInBytes, workspaceInBytes));
    }

    private static native int cusolverSpCcsrqrBufferInfoBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, csrqrInfo var9, long[] var10, long[] var11);

    public static int cusolverSpZcsrqrBufferInfoBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, int batchSize, csrqrInfo info, long[] internalDataInBytes, long[] workspaceInBytes) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrqrBufferInfoBatchedNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, batchSize, info, internalDataInBytes, workspaceInBytes));
    }

    private static native int cusolverSpZcsrqrBufferInfoBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, csrqrInfo var9, long[] var10, long[] var11);

    public static int cusolverSpScsrqrsvBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, Pointer x, int batchSize, csrqrInfo info, Pointer pBuffer) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpScsrqrsvBatchedNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, x, batchSize, info, pBuffer));
    }

    private static native int cusolverSpScsrqrsvBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, csrqrInfo var11, Pointer var12);

    public static int cusolverSpDcsrqrsvBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, Pointer x, int batchSize, csrqrInfo info, Pointer pBuffer) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpDcsrqrsvBatchedNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, x, batchSize, info, pBuffer));
    }

    private static native int cusolverSpDcsrqrsvBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, csrqrInfo var11, Pointer var12);

    public static int cusolverSpCcsrqrsvBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, Pointer x, int batchSize, csrqrInfo info, Pointer pBuffer) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpCcsrqrsvBatchedNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, x, batchSize, info, pBuffer));
    }

    private static native int cusolverSpCcsrqrsvBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, csrqrInfo var11, Pointer var12);

    public static int cusolverSpZcsrqrsvBatched(cusolverSpHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer b, Pointer x, int batchSize, csrqrInfo info, Pointer pBuffer) {
        return JCusolverSp.checkResult(JCusolverSp.cusolverSpZcsrqrsvBatchedNative(handle, m, n, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, b, x, batchSize, info, pBuffer));
    }

    private static native int cusolverSpZcsrqrsvBatchedNative(cusolverSpHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, csrqrInfo var11, Pointer var12);

    static {
        JCusolver.initialize();
    }
}

