/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.recompile;

import java.util.HashMap;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class RecompileStatus {
    private final long _tid;
    private final boolean _inplace;
    private final Recompiler.ResetType _reset;
    private final boolean _initialCodegen;
    private boolean _requiresRecompile = false;
    private final HashMap<String, DataCharacteristics> _lastTWrites = new HashMap();

    public RecompileStatus() {
        this(0L, true, Recompiler.ResetType.NO_RESET, false);
    }

    public RecompileStatus(boolean initialCodegen) {
        this(0L, true, Recompiler.ResetType.NO_RESET, initialCodegen);
    }

    public RecompileStatus(long tid, boolean inplace, Recompiler.ResetType reset, boolean initialCodegen) {
        this._tid = tid;
        this._inplace = inplace;
        this._reset = reset;
        this._initialCodegen = initialCodegen;
    }

    public HashMap<String, DataCharacteristics> getTWriteStats() {
        return this._lastTWrites;
    }

    public long getTID() {
        return this._tid;
    }

    public boolean hasThreadID() {
        return ProgramBlock.isThreadID(this._tid);
    }

    public boolean isInPlace() {
        return this._inplace;
    }

    public boolean isReset() {
        return this._reset.isReset();
    }

    public Recompiler.ResetType getReset() {
        return this._reset;
    }

    public boolean isInitialCodegen() {
        return this._initialCodegen;
    }

    public void trackRecompile(boolean flag) {
        this._requiresRecompile |= flag;
    }

    public boolean requiresRecompile() {
        return this._requiresRecompile;
    }

    public Object clone() {
        RecompileStatus ret = new RecompileStatus(this._tid, this._inplace, this._reset, this._initialCodegen);
        ret._lastTWrites.putAll(this._lastTWrites);
        return ret;
    }
}

