/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.HashMap;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.sysds.common.Types;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.FunctionCallIdentifier;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.IntIdentifier;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.VariableSet;

public class IterablePredicate
extends Expression {
    private DataIdentifier _iterVar;
    private Expression _fromExpr;
    private Expression _toExpr;
    private Expression _incrementExpr;
    private HashMap<String, String> _parforParams;

    public IterablePredicate(ParserRuleContext ctx, DataIdentifier iterVar, Expression fromExpr, Expression toExpr, Expression incrementExpr, HashMap<String, String> parForParamValues, String filename) {
        this._iterVar = iterVar;
        this._fromExpr = fromExpr;
        this._toExpr = toExpr;
        this._incrementExpr = incrementExpr;
        this._parforParams = parForParamValues;
        this.setCtxValuesAndFilename(ctx, filename);
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._fromExpr.variablesRead());
        result.addVariables(this._toExpr.variablesRead());
        if (this._incrementExpr != null) {
            result.addVariables(this._incrementExpr.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        result.addVariable(this._iterVar.getName(), this._iterVar);
        return result;
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        throw new LanguageException(this.printErrorLocation() + "rewriteExpression not supported for IterablePredicate");
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        DataIdentifier otherDI;
        if (this._iterVar instanceof FunctionCallIdentifier || this._fromExpr instanceof FunctionCallIdentifier || this._toExpr instanceof FunctionCallIdentifier || this._incrementExpr instanceof FunctionCallIdentifier) {
            this.raiseValidateError("user-defined function calls not supported for iterable predicates", false, "Unsupported Expression");
        }
        if (ids.containsKey(this._iterVar.getName()) && ((otherDI = ids.get(this._iterVar.getName())).getDataType() != Types.DataType.SCALAR || otherDI.getValueType() != Types.ValueType.INT64)) {
            this.raiseValidateError("iterable predicate in for loop '" + this._iterVar.getName() + "' must be a scalar integer", conditional);
        }
        this._iterVar.setIntProperties();
        ids.put(this._iterVar.getName(), this._iterVar);
        if (this._incrementExpr == null && this._fromExpr instanceof ConstIdentifier && this._toExpr instanceof ConstIdentifier) {
            ConstIdentifier cFrom = (ConstIdentifier)this._fromExpr;
            ConstIdentifier cTo = (ConstIdentifier)this._toExpr;
            this._incrementExpr = new IntIdentifier(cFrom.getLongValue() <= cTo.getLongValue() ? 1L : -1L, (ParseInfo)this);
        }
        this._fromExpr.validateExpression(ids, constVars, conditional);
        this._toExpr.validateExpression(ids, constVars, conditional);
        if (this._incrementExpr != null) {
            this._incrementExpr.validateExpression(ids, constVars, conditional);
        }
        this.checkNumericScalarOutput(this._fromExpr);
        this.checkNumericScalarOutput(this._toExpr);
        this.checkNumericScalarOutput(this._incrementExpr);
    }

    public DataIdentifier getIterVar() {
        return this._iterVar;
    }

    public void setIterVar(DataIdentifier iterVar) {
        this._iterVar = iterVar;
    }

    public Expression getFromExpr() {
        return this._fromExpr;
    }

    public void setFromExpr(Expression from) {
        this._fromExpr = from;
    }

    public Expression getToExpr() {
        return this._toExpr;
    }

    public void setToExpr(Expression to) {
        this._toExpr = to;
    }

    public Expression getIncrementExpr() {
        return this._incrementExpr;
    }

    public void setIncrementExpr(Expression increment) {
        this._incrementExpr = increment;
    }

    public HashMap<String, String> getParForParams() {
        return this._parforParams;
    }

    public void setParForParams(HashMap<String, String> params) {
        this._parforParams = params;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this._iterVar.getName());
        sb.append(" in seq(");
        sb.append(this._fromExpr.toString());
        sb.append(",");
        sb.append(this._toExpr.toString());
        if (this._incrementExpr != null) {
            sb.append(",");
            sb.append(this._incrementExpr.toString());
        }
        sb.append(")");
        if (this._parforParams != null && this._parforParams.size() > 0) {
            for (String key : this._parforParams.keySet()) {
                sb.append(",");
                sb.append(key);
                sb.append("=");
                sb.append(this._parforParams.get(key));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private void checkNumericScalarOutput(Expression expr) {
        if (expr == null || expr.getOutput() == null) {
            return;
        }
        Identifier ident = expr.getOutput();
        if (ident.getDataType() == Types.DataType.MATRIX || ident.getDataType() == Types.DataType.SCALAR && (ident.getValueType() == Types.ValueType.BOOLEAN || ident.getValueType() == Types.ValueType.STRING)) {
            throw new LanguageException(this.printErrorLocation() + "expression in iterable predicate in for loop '" + expr.toString() + "' must return a numeric scalar");
        }
    }
}

