/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class DeltaDictionary
extends Dictionary {
    private static final long serialVersionUID = -5700139221491143705L;
    private final int _numCols;

    public DeltaDictionary(double[] values, int numCols) {
        super(values);
        this._numCols = numCols;
    }

    @Override
    public DeltaDictionary applyScalarOp(ScalarOperator op) {
        double[] retV = new double[this._values.length];
        if (op.fn instanceof Multiply || op.fn instanceof Divide) {
            for (int i = 0; i < this._values.length; ++i) {
                retV[i] = op.executeScalar(this._values[i]);
            }
        } else if (op.fn instanceof Plus || op.fn instanceof Minus) {
            for (int i = 0; i < this._values.length; ++i) {
                retV[i] = i < this._numCols ? op.executeScalar(this._values[i]) : this._values[i];
            }
        } else {
            throw new NotImplementedException();
        }
        return new DeltaDictionary(retV, this._numCols);
    }
}

