/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.sample;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.estim.sample.HassAndStokes;
import org.apache.sysds.runtime.compress.estim.sample.ShlosserEstimator;
import org.apache.sysds.runtime.compress.estim.sample.ShlosserJackknifeEstimator;
import org.apache.sysds.runtime.compress.estim.sample.SmoothedJackknifeEstimator;

public interface SampleEstimatorFactory {
    public static final Log LOG = LogFactory.getLog((String)SampleEstimatorFactory.class.getName());

    public static int distinctCount(int[] frequencies, int nRows, int sampleSize, EstimationType type) {
        return SampleEstimatorFactory.distinctCount(frequencies, nRows, sampleSize, type, null);
    }

    public static int distinctCount(int[] frequencies, int nRows, int sampleSize, EstimationType type, HashMap<Integer, Double> solveCache) {
        if (frequencies == null || frequencies.length == 0) {
            return 0;
        }
        int[] invHist = SampleEstimatorFactory.getInvertedFrequencyHistogram(frequencies);
        int est = SampleEstimatorFactory.distinctCountWithHistogram(frequencies.length, invHist, frequencies, nRows, sampleSize, type, solveCache);
        int low = Math.max(frequencies.length, est);
        int high = Math.min(low, nRows - sampleSize + frequencies.length);
        return high;
    }

    private static int distinctCountWithHistogram(int numVals, int[] invHist, int[] frequencies, int nRows, int sampleSize, EstimationType type, HashMap<Integer, Double> solveCache) {
        switch (type) {
            case ShlosserEstimator: {
                return ShlosserEstimator.distinctCount(numVals, invHist, nRows, sampleSize);
            }
            case ShlosserJackknifeEstimator: {
                return ShlosserJackknifeEstimator.distinctCount(numVals, frequencies, invHist, nRows, sampleSize);
            }
            case SmoothedJackknifeEstimator: {
                return SmoothedJackknifeEstimator.distinctCount(numVals, invHist, nRows, sampleSize);
            }
            case HassAndStokesNoSolveCache: {
                return HassAndStokes.distinctCount(numVals, invHist, nRows, sampleSize, null);
            }
        }
        return HassAndStokes.distinctCount(numVals, invHist, nRows, sampleSize, solveCache);
    }

    private static int[] getInvertedFrequencyHistogram(int[] frequencies) {
        int numVals = frequencies.length;
        int maxCount = 0;
        for (int i = 0; i < numVals; ++i) {
            int v = frequencies[i];
            if (v <= maxCount) continue;
            maxCount = v;
        }
        int[] freqCounts = new int[maxCount];
        for (int i = 0; i < numVals; ++i) {
            int n = frequencies[i] - 1;
            freqCounts[n] = freqCounts[n] + 1;
        }
        return freqCounts;
    }

    public static enum EstimationType {
        HassAndStokes,
        ShlosserEstimator,
        ShlosserJackknifeEstimator,
        SmoothedJackknifeEstimator,
        HassAndStokesNoSolveCache;

    }
}

