/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;

public class IntArrayList {
    private static final int INIT_CAPACITY = 4;
    private static final int RESIZE_FACTOR = 2;
    private int[] _data = null;
    private int _size;

    public IntArrayList() {
        this._data = null;
        this._size = 0;
    }

    public IntArrayList(int initialSize) {
        this._data = new int[initialSize];
        this._size = 0;
    }

    public IntArrayList(int[] values) {
        this._data = values;
        this._size = values.length;
    }

    public int size() {
        return this._size;
    }

    public void appendValue(int value) {
        if (this._data == null) {
            this._data = new int[4];
        } else if (this._size + 1 >= this._data.length) {
            this.resize();
        }
        this._data[this._size] = value;
        ++this._size;
    }

    public int[] extractValues() {
        return this._data;
    }

    public int get(int index) {
        if (this._data != null) {
            return this._data[index];
        }
        throw new RuntimeException("invalid index to get");
    }

    public int[] extractValues(boolean trim) {
        int[] ret = this.extractValues();
        return trim && this._size < ret.length ? Arrays.copyOfRange(ret, 0, this._size) : ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            throw new RuntimeException("IntArrayList resize leads to integer overflow: size=" + this._size);
        }
        this._data = Arrays.copyOf(this._data, this._data.length * 2);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[i] + "]");
        return sb.toString();
    }
}

