/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.Serializable;

public abstract class SparseRow
implements Serializable {
    private static final long serialVersionUID = 5806895317005796456L;

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract double[] values();

    public abstract int[] indexes();

    public abstract void reset(int var1, int var2);

    public abstract boolean set(int var1, double var2);

    public abstract boolean add(int var1, double var2);

    public abstract void append(int var1, double var2);

    public abstract double get(int var1);

    public abstract void sort();

    public abstract void compact();

    public abstract void compact(double var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int s = this.size();
        if (s == 0) {
            return "";
        }
        int[] indexes = this.indexes();
        double[] values = this.values();
        int rowDigits = (int)Math.max(Math.ceil(Math.log10(indexes[s - 1])), 1.0);
        for (int i = 0; i < s; ++i) {
            if (values[i] == (double)((long)values[i])) {
                sb.append(String.format("%" + rowDigits + "d:%d", indexes[i], (long)values[i]));
            } else {
                sb.append(String.format("%" + rowDigits + "d:%s", indexes[i], Double.toString(values[i])));
            }
            if (i + 1 >= s) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

