/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.utils.MemoryEstimates;

public interface ArrayFactory {
    public static final int bitSetSwitchPoint = 64;

    public static StringArray create(String[] col) {
        return new StringArray(col);
    }

    public static BooleanArray create(boolean[] col) {
        return new BooleanArray(col);
    }

    public static BitSetArray create(BitSet col, int size) {
        return new BitSetArray(col, size);
    }

    public static IntegerArray create(int[] col) {
        return new IntegerArray(col);
    }

    public static LongArray create(long[] col) {
        return new LongArray(col);
    }

    public static FloatArray create(float[] col) {
        return new FloatArray(col);
    }

    public static DoubleArray create(double[] col) {
        return new DoubleArray(col);
    }

    public static CharArray create(char[] col) {
        return new CharArray(col);
    }

    public static <T> OptionalArray<T> create(T[] col) {
        return new OptionalArray<T>(col);
    }

    public static long getInMemorySize(Types.ValueType type, int _numRows) {
        switch (type) {
            case BOOLEAN: {
                if (_numRows > 64) {
                    return Array.baseMemoryCost() + (long)MemoryEstimates.longArrayCost(_numRows >> 7);
                }
                return Array.baseMemoryCost() + (long)MemoryEstimates.booleanArrayCost(_numRows);
            }
            case INT64: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.longArrayCost(_numRows);
            }
            case FP64: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.doubleArrayCost(_numRows);
            }
            case UINT4: 
            case UINT8: 
            case INT32: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.intArrayCost(_numRows);
            }
            case FP32: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.floatArrayCost(_numRows);
            }
            case STRING: {
                return Array.baseMemoryCost() + MemoryEstimates.stringCost(12L) * (long)_numRows;
            }
            case CHARACTER: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.charArrayCost(_numRows);
            }
        }
        throw new DMLRuntimeException("Invalid type to estimate size of :" + type);
    }

    public static Array<?> allocate(Types.ValueType v, int nRow, String val) {
        Array<?> a = ArrayFactory.allocate(v, nRow);
        a.fill(val);
        return a;
    }

    public static Array<?> allocateOptional(Types.ValueType v, int nRow) {
        switch (v) {
            case BOOLEAN: {
                if (nRow > 64) {
                    return new OptionalArray<Boolean>(new BitSetArray(nRow), true);
                }
                return new OptionalArray<Boolean>(new BooleanArray(new boolean[nRow]), true);
            }
            case UINT4: 
            case UINT8: 
            case INT32: {
                return new OptionalArray<Integer>(new IntegerArray(new int[nRow]), true);
            }
            case INT64: {
                return new OptionalArray<Long>(new LongArray(new long[nRow]), true);
            }
            case FP32: {
                return new OptionalArray<Float>(new FloatArray(new float[nRow]), true);
            }
            case FP64: {
                return new OptionalArray<Double>(new DoubleArray(new double[nRow]), true);
            }
            case CHARACTER: {
                return new OptionalArray<Character>(new CharArray(new char[nRow]), true);
            }
        }
        return new StringArray(new String[nRow]);
    }

    public static ABooleanArray allocateBoolean(int nRow) {
        if (nRow > 64) {
            return new BitSetArray(nRow);
        }
        return new BooleanArray(new boolean[nRow]);
    }

    public static Array<?> allocate(Types.ValueType v, int nRow) {
        switch (v) {
            case BOOLEAN: {
                return ArrayFactory.allocateBoolean(nRow);
            }
            case UINT4: 
            case UINT8: 
            case INT32: {
                return new IntegerArray(new int[nRow]);
            }
            case INT64: {
                return new LongArray(new long[nRow]);
            }
            case FP32: {
                return new FloatArray(new float[nRow]);
            }
            case FP64: {
                return new DoubleArray(new double[nRow]);
            }
            case CHARACTER: {
                return new CharArray(new char[nRow]);
            }
        }
        return new StringArray(new String[nRow]);
    }

    public static Array<?> read(DataInput in, int nRow) throws IOException {
        Array arr;
        FrameArrayType v = FrameArrayType.values()[in.readByte()];
        switch (v) {
            case BITSET: {
                arr = new BitSetArray(nRow);
                break;
            }
            case BOOLEAN: {
                arr = new BooleanArray(new boolean[nRow]);
                break;
            }
            case INT64: {
                arr = new LongArray(new long[nRow]);
                break;
            }
            case FP64: {
                arr = new DoubleArray(new double[nRow]);
                break;
            }
            case INT32: {
                arr = new IntegerArray(new int[nRow]);
                break;
            }
            case FP32: {
                arr = new FloatArray(new float[nRow]);
                break;
            }
            case CHARACTER: {
                arr = new CharArray(new char[nRow]);
                break;
            }
            case OPTIONAL: {
                return OptionalArray.readOpt(in, nRow);
            }
            default: {
                arr = new StringArray(new String[nRow]);
            }
        }
        arr.readFields(in);
        return arr;
    }

    public static <C> Array<C> append(Array<?> a, Array<?> b) {
        Types.ValueType tb;
        Types.ValueType tc;
        Types.ValueType ta = a.getValueType();
        Array<?> ac = ta != (tc = Types.ValueType.getHighestCommonType(ta, tb = b.getValueType())) ? a.changeType(tc) : a;
        Array<?> bc = tb != tc ? b.changeType(tc) : b;
        return ac.append(bc);
    }

    public static <C> Array<C> set(Array<?> target, Array<?> src, int rl, int ru, int rlen) {
        if (target == null) {
            target = src.getFrameArrayType() == FrameArrayType.OPTIONAL ? ArrayFactory.allocateOptional(src.getValueType(), rlen) : ArrayFactory.allocate(src.getValueType(), rlen);
        } else if (target.getFrameArrayType() != FrameArrayType.OPTIONAL && src.getFrameArrayType() == FrameArrayType.OPTIONAL) {
            target = new OptionalArray(target, false);
        }
        Types.ValueType ta = target.getValueType();
        Types.ValueType tb = src.getValueType();
        Types.ValueType tc = Types.ValueType.getHighestCommonType(ta, tb);
        Array<?> targetC = ta != tc ? target.changeType(tc) : target;
        Array<?> srcC = tb != tc ? src.changeType(tc) : src;
        targetC.set(rl, ru, srcC);
        return targetC;
    }

    public static Object parseString(String s, Types.ValueType v) {
        switch (v) {
            case BOOLEAN: {
                return BooleanArray.parseBoolean(s);
            }
            case CHARACTER: {
                return Character.valueOf(CharArray.parseChar(s));
            }
            case FP32: {
                return Float.valueOf(FloatArray.parseFloat(s));
            }
            case FP64: {
                return DoubleArray.parseDouble(s);
            }
            case UINT4: 
            case UINT8: 
            case INT32: {
                return IntegerArray.parseInt(s);
            }
            case INT64: {
                return LongArray.parseLong(s);
            }
        }
        return s;
    }

    public static Object defaultNullValue(Types.ValueType v) {
        return ArrayFactory.parseString(null, v);
    }

    public static enum FrameArrayType {
        STRING,
        BOOLEAN,
        BITSET,
        INT32,
        INT64,
        FP32,
        FP64,
        CHARACTER,
        OPTIONAL;

    }
}

