/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.MatrixMatrixBuiltinGPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.ScalarMatrixBuiltinGPUInstruction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class BuiltinBinaryGPUInstruction
extends GPUInstruction {
    private int _arity;

    protected BuiltinBinaryGPUInstruction(Operator op, CPOperand input1, CPOperand input2, CPOperand output, String opcode, String istr, int _arity) {
        super(op, input1, input2, output, opcode, istr);
        this._arity = _arity;
    }

    public static BuiltinBinaryGPUInstruction parseInstruction(String str) {
        boolean isMatrixScalar;
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        in1.split(parts[1]);
        in2.split(parts[2]);
        out.split(parts[3]);
        if ((in1.getDataType() == Types.DataType.MATRIX || in2.getDataType() == Types.DataType.MATRIX) && out.getDataType() != Types.DataType.MATRIX) {
            throw new DMLRuntimeException("Element-wise matrix operations between variables " + in1.getName() + " and " + in2.getName() + " must produce a matrix, which " + out.getName() + " is not");
        }
        Builtin func = Builtin.getBuiltinFnObject(opcode);
        boolean isMatrixMatrix = in1.getDataType() == Types.DataType.MATRIX && in2.getDataType() == Types.DataType.MATRIX;
        boolean bl = isMatrixScalar = in1.getDataType() == Types.DataType.MATRIX && in2.getDataType() == Types.DataType.SCALAR || in1.getDataType() == Types.DataType.SCALAR && in2.getDataType() == Types.DataType.MATRIX;
        if (in1.getDataType() == Types.DataType.SCALAR && in2.getDataType() == Types.DataType.SCALAR) {
            throw new DMLRuntimeException("GPU : Unsupported GPU builtin operations on 2 scalars");
        }
        if (isMatrixMatrix && opcode.equals("solve")) {
            return new MatrixMatrixBuiltinGPUInstruction(new BinaryOperator(func), in1, in2, out, opcode, str, 2);
        }
        if (isMatrixScalar && (opcode.equals("min") || opcode.equals("max"))) {
            return new ScalarMatrixBuiltinGPUInstruction(new BinaryOperator(func), in1, in2, out, opcode, str, 2);
        }
        throw new DMLRuntimeException("GPU : Unsupported GPU builtin operations on a matrix and a scalar:" + opcode);
    }
}

