/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.functions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import scala.Tuple2;

public class ReplicateBlockFunction
implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = -1184696764516975609L;
    private final long _len;
    private final long _blen;
    private final boolean _left;
    private final boolean _deep;

    public ReplicateBlockFunction(long len, long blen, boolean left) {
        this(len, blen, left, false);
    }

    public ReplicateBlockFunction(long len, long blen, boolean left, boolean deep) {
        this._len = len;
        this._blen = blen;
        this._left = left;
        this._deep = deep;
    }

    public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
        MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
        MatrixBlock blkIn = (MatrixBlock)arg0._2();
        long numBlocks = (long)Math.ceil((double)this._len / (double)this._blen);
        if (this._left) {
            long i = ixIn.getRowIndex();
            for (long j = 1L; j <= numBlocks; ++j) {
                MatrixIndexes tmpix = new MatrixIndexes(i, j);
                MatrixBlock tmpblk = this._deep ? new MatrixBlock(blkIn) : blkIn;
                ret.add(new Tuple2((Object)tmpix, (Object)tmpblk));
            }
        } else {
            long j = ixIn.getColumnIndex();
            for (long i = 1L; i <= numBlocks; ++i) {
                MatrixIndexes tmpix = new MatrixIndexes(i, j);
                MatrixBlock tmpblk = this._deep ? new MatrixBlock(blkIn) : blkIn;
                ret.add(new Tuple2((Object)tmpix, (Object)tmpblk));
            }
        }
        return ret.iterator();
    }
}

