/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.H5SymbolTableEntry;

public class H5GroupSymbolTableNode {
    private static final byte[] NODE_SIGNATURE = "SNOD".getBytes(StandardCharsets.US_ASCII);
    private final short numberOfEntries;
    private final H5SymbolTableEntry[] symbolTableEntries;
    private final int headerSize = 8;
    private final H5RootObject rootObject;

    public H5GroupSymbolTableNode(H5RootObject rootObject, long address) {
        this.rootObject = rootObject;
        try {
            ByteBuffer header = rootObject.readBufferFromAddress(address, 8);
            byte[] formatSignatureBytes = new byte[4];
            header.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(NODE_SIGNATURE, formatSignatureBytes)) {
                throw new H5RuntimeException("Group symbol table Node signature not matched");
            }
            rootObject.setGroupSymbolTableNodeVersion(header.get());
            header.position(6);
            byte[] twoBytes = new byte[2];
            header.get(twoBytes);
            this.numberOfEntries = ByteBuffer.wrap(twoBytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
            long symbolTableEntryBytes = (long)rootObject.getSuperblock().sizeOfOffsets * 2L + 8L + 16L;
            this.symbolTableEntries = new H5SymbolTableEntry[this.numberOfEntries];
            for (int i = 0; i < this.numberOfEntries; ++i) {
                long offset = address + 8L + (long)i * symbolTableEntryBytes;
                this.symbolTableEntries[i] = new H5SymbolTableEntry(rootObject, offset);
            }
        }
        catch (Exception e) {
            throw new H5RuntimeException("Error reading Group symbol table node", e);
        }
    }

    public H5GroupSymbolTableNode(H5RootObject rootObject, short numberOfEntries, H5SymbolTableEntry[] symbolTableEntries) {
        this.rootObject = rootObject;
        this.numberOfEntries = numberOfEntries;
        this.symbolTableEntries = symbolTableEntries;
    }

    public void toBuffer(H5BufferBuilder bb) {
        bb.writeBytes(NODE_SIGNATURE);
        bb.writeByte(this.rootObject.getGroupSymbolTableNodeVersion());
        bb.writeByte(0);
        bb.writeShort(this.numberOfEntries);
        for (H5SymbolTableEntry symbolTableEntry : this.symbolTableEntries) {
            symbolTableEntry.toBuffer(bb);
        }
    }

    public short getVersion() {
        return this.rootObject.getGroupSymbolTableNodeVersion();
    }

    public short getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public H5SymbolTableEntry[] getSymbolTableEntries() {
        return (H5SymbolTableEntry[])ArrayUtils.clone((Object[])this.symbolTableEntries);
    }
}

